/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.utilities.location.Location;

public class Image
implements Comparable<Image> {
    private final ImageMetaData metaData;
    private final Store store;

    Image(Store store, ImageMetaData metaData) {
        this.store = store;
        this.metaData = metaData;
    }

    public ImageMetaData getMetaData() {
        return this.metaData;
    }

    public List<Source> listSources() throws DAQException {
        ArrayList<Source> result = new ArrayList<Source>();
        for (Location location : this.metaData.getLocations()) {
            result.add(new Source(this, location));
        }
        return result;
    }

    public void delete() throws DAQException {
        int rc = this.store.deleteImage(this.metaData.getId());
        if (rc != 0) {
            throw new DAQException(String.format("Delete image failed (rc=%d)", rc));
        }
    }

    public void moveTo(String folderName) throws DAQException {
        int rc = this.store.moveImageToFolder(this.metaData.getId(), folderName);
        if (rc != 0) {
            throw new DAQException(String.format("Move image to folder %s failed (rc=%d)", folderName, rc));
        }
    }

    public Source addSource(Location location, int[] registerValues) throws DAQException {
        if (!this.metaData.getLocations().contains(location)) {
            throw new IllegalArgumentException("Invalid location " + location + " for image " + this);
        }
        return new Source(this, this.store.addSourceToImage(this.metaData.getId(), location, registerValues));
    }

    public Source findSource(Location location) {
        if (!this.metaData.getLocations().contains(location)) {
            throw new IllegalArgumentException("Invalid location " + location + " for image " + this);
        }
        return new Source(this, location);
    }

    public Store getStore() {
        return this.store;
    }

    @Override
    public int compareTo(Image o) {
        return this.metaData.getName().compareTo(o.metaData.getName());
    }

    public int hashCode() {
        return (int)this.metaData.getId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)obj;
        return this.metaData.getId() == other.metaData.getId();
    }

    public String toString() {
        return "Image{metaData=" + this.metaData + '}';
    }
}

