/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.Version;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageMetaDataTest {
    @Test
    public void imageMetaDataSerializableTest() throws IOException, ClassNotFoundException {
        ImageMetaData imd = new ImageMetaData("test", "raw", "testAnnnotation", 5, (Set)LocationSet.of((String[])new String[]{"R22/Reb1"}));
        Object result = ImageMetaDataTest.serializeDeserialize(imd);
        Assert.assertTrue((boolean)(result instanceof ImageMetaData));
        ImageMetaData imd2 = (ImageMetaData)result;
        Assert.assertEquals((Object)imd.getAnnotation(), (Object)imd2.getAnnotation());
        Assert.assertEquals((Object)imd.getName(), (Object)imd2.getName());
        Assert.assertEquals((long)imd.getOpcode(), (long)imd2.getOpcode());
        Assert.assertEquals((Object)imd.getLocations(), (Object)imd2.getLocations());
    }

    @Test
    public void sourceMetaDataSerializableTest() throws IOException, ClassNotFoundException {
        SourceMetaData smd = new SourceMetaData(2, 3, "platform", new Version("tag", 1000000L, false, 99), 99, 0L, 0L, 0, 0, new int[]{1, 2, 3, 4, 5});
        Object result = ImageMetaDataTest.serializeDeserialize(smd);
        Assert.assertTrue((boolean)(result instanceof SourceMetaData));
        SourceMetaData smd2 = (SourceMetaData)result;
        Assert.assertEquals((long)smd.getFirmware(), (long)smd2.getFirmware());
        Assert.assertEquals((long)smd.getLength(), (long)smd2.getLength());
        Assert.assertArrayEquals((int[])smd.getRegisterValues(), (int[])smd2.getRegisterValues());
        Assert.assertEquals((long)smd.getSerialNumber(), (long)smd2.getSerialNumber());
    }

    static Object serializeDeserialize(Object in) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(in);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Object object = ois.readObject();
            return object;
        }
    }
}

