/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.ByteChannel;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.channel.BadPixelDetector;
import org.lsst.ccs.daq.ims.channel.Decompress18BitChannel;
import org.lsst.ccs.daq.ims.channel.NullIntWriter;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;
import org.lsst.ccs.daq.ims.channel.XORWritableIntChannel;

public class RawDump {
    public static void main(String[] args) throws IOException, DAQException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try (Store store = new Store("camera");){
            Folder raw = store.getCatalog().find("raw");
            List images = raw.listImages();
            Collections.sort(images);
            for (Image image : images) {
                List sources = image.listSources();
                for (Source source : sources) {
                    if (source.getMetaData().getLength() <= 0L) continue;
                    try {
                        ByteChannel openChannel = source.openChannel(Source.ChannelMode.READ);
                        Throwable throwable = null;
                        try {
                            NullIntWriter devNull = new NullIntWriter();
                            Throwable throwable2 = null;
                            try {
                                BadPixelDetector bad = new BadPixelDetector((WritableIntChannel)devNull);
                                Throwable throwable3 = null;
                                try {
                                    XORWritableIntChannel xor = new XORWritableIntChannel((WritableIntChannel)bad, 131071);
                                    Throwable throwable4 = null;
                                    try {
                                        Decompress18BitChannel decompress18BitChannel = new Decompress18BitChannel((WritableIntChannel)xor);
                                        Throwable throwable5 = null;
                                        try {
                                            while (true) {
                                                buffer.clear();
                                                int read = openChannel.read(buffer);
                                                if (read < 0) break;
                                                buffer.flip();
                                                IntBuffer intBuffer = buffer.asIntBuffer();
                                                decompress18BitChannel.write(intBuffer);
                                            }
                                            System.out.printf("%s %s %d/%d\n", image.getMetaData().getName(), source.getLocation(), bad.getBadPixels(), bad.getTotalPixels());
                                        }
                                        catch (Throwable throwable6) {
                                            throwable5 = throwable6;
                                            throw throwable6;
                                        }
                                        finally {
                                            if (decompress18BitChannel == null) continue;
                                            if (throwable5 != null) {
                                                try {
                                                    decompress18BitChannel.close();
                                                }
                                                catch (Throwable throwable7) {
                                                    throwable5.addSuppressed(throwable7);
                                                }
                                                continue;
                                            }
                                            decompress18BitChannel.close();
                                        }
                                    }
                                    catch (Throwable throwable8) {
                                        throwable4 = throwable8;
                                        throw throwable8;
                                    }
                                    finally {
                                        if (xor == null) continue;
                                        if (throwable4 != null) {
                                            try {
                                                xor.close();
                                            }
                                            catch (Throwable throwable9) {
                                                throwable4.addSuppressed(throwable9);
                                            }
                                            continue;
                                        }
                                        xor.close();
                                    }
                                }
                                catch (Throwable throwable10) {
                                    throwable3 = throwable10;
                                    throw throwable10;
                                }
                                finally {
                                    if (bad == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            bad.close();
                                        }
                                        catch (Throwable throwable11) {
                                            throwable3.addSuppressed(throwable11);
                                        }
                                        continue;
                                    }
                                    bad.close();
                                }
                            }
                            catch (Throwable throwable12) {
                                throwable2 = throwable12;
                                throw throwable12;
                            }
                            finally {
                                if (devNull == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        devNull.close();
                                    }
                                    catch (Throwable throwable13) {
                                        throwable2.addSuppressed(throwable13);
                                    }
                                    continue;
                                }
                                devNull.close();
                            }
                        }
                        catch (Throwable throwable14) {
                            throwable = throwable14;
                            throw throwable14;
                        }
                        finally {
                            if (openChannel == null) continue;
                            if (throwable != null) {
                                try {
                                    openChannel.close();
                                }
                                catch (Throwable throwable15) {
                                    throwable.addSuppressed(throwable15);
                                }
                                continue;
                            }
                            openChannel.close();
                        }
                    }
                    catch (IOException x) {
                        System.out.printf("%s %s Error\n", image.getMetaData().getName(), source.getLocation());
                    }
                }
            }
        }
    }
}

