/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.example;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.ByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.Utils;
import org.lsst.ccs.daq.ims.channel.FitsIntReader;
import org.lsst.ccs.daq.ims.example.FitsFile;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.location.LocationSet;

public class CommandTool {
    private static final FitsHeadersSpecificationsBuilder HEADER_SPEC_BUILDER = new FitsHeadersSpecificationsBuilder();
    private static final Logger LOG;
    private static final Pattern PATH_PATTERN;
    private Store store;
    private final FocalPlane focalPlane = FocalPlane.createFocalPlane();

    public CommandTool() {
        ((Raft)this.focalPlane.getChild(2, 2)).setCCDType(CCDType.getCCDType((String)"itl"));
    }

    @Command(name="connect", description="Connect to a DAQ store")
    public void connect(@Argument(name="partition", description="Partition name") String partition) throws DAQException {
        if (this.store != null) {
            this.store.close();
        }
        this.store = new Store(partition);
    }

    @Command(name="close", description="Close DAQ store")
    public void close() throws DAQException {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Command(name="ls", description="List folders/files")
    public void list(@Argument(name="folder", description="Path", defaultValue="") String path) throws DAQException {
        this.checkStore();
        Matcher matcher = PATH_PATTERN.matcher(path);
        if (!matcher.matches()) {
            throw new RuntimeException("Illegal path: " + path);
        }
        if (path.trim().isEmpty()) {
            List<Folder> list = this.store.getCatalog().list();
            Collections.sort(list);
            list.forEach(folder -> System.out.println(folder.getName()));
            long capacity = this.store.getCapacity();
            long remaining = this.store.getRemaining();
            System.out.printf("%s/%s (%3.3g%%) bytes used\n", Utils.humanReadableByteCount(capacity - remaining), Utils.humanReadableByteCount(capacity, false), 100.0 * (double)(capacity - remaining) / (double)capacity);
        } else if (matcher.matches() && matcher.group(2).isEmpty()) {
            Folder folder2 = this.store.getCatalog().find(matcher.group(1));
            if (folder2 == null) {
                throw new RuntimeException("No such folder: " + matcher.group(1));
            }
            List<Image> images = folder2.listImages();
            Collections.sort(images);
            for (Image image : images) {
                System.out.printf("%s %s %s %s\n", image.getMetaData().getName(), this.imageSize(image), image.getMetaData().getTimestamp(), image.getMetaData().getAnnotation());
            }
        } else {
            Image image = this.imageFromPath(matcher);
            System.out.printf("%s %s %s %s\n", image.getMetaData().getName(), this.imageSize(image), image.getMetaData().getTimestamp(), image.getMetaData().getAnnotation());
            List<Source> sources = image.listSources();
            Collections.sort(sources);
            for (Source source : sources) {
                SourceMetaData smd = source.getMetaData();
                System.out.printf("   %s %s %s\n", smd.getLocation(), Utils.humanReadableByteCount(smd.getLength()), Arrays.toString(smd.getRegisterValues()));
            }
        }
    }

    @Command(name="mkdir", description="Create new folder")
    public void mkdir(String folderName) throws DAQException {
        this.checkStore();
        this.store.getCatalog().insert(folderName);
    }

    @Command(name="rmdir", description="Delete folder")
    public void rmdir(String folderName) throws DAQException {
        this.checkStore();
        this.store.getCatalog().remove(folderName);
    }

    @Command(name="rm", description="Delete image")
    public void rm(String path) throws DAQException {
        this.checkStore();
        Image image = this.imageFromPath(path);
        image.delete();
    }

    @Command(name="mv", description="Move image")
    public void mv(String path, String targetFolderName) throws DAQException {
        this.checkStore();
        Image image = this.imageFromPath(path);
        Folder target = this.store.getCatalog().find(targetFolderName);
        if (target == null) {
            throw new RuntimeException("No such folder: " + target);
        }
        image.moveTo(targetFolderName);
    }

    @Command(name="locations", description="List configured locations")
    public LocationSet locations() throws DAQException {
        this.checkStore();
        return this.store.getConfiguredSources();
    }

    @Command(name="readRaw")
    public void readRaw(String path, @Argument(defaultValue=".", description="Folder where .raw files will be written") File dir, @Argument(defaultValue="1048576") int bufferSize) throws FileNotFoundException, DAQException, IOException, InterruptedException, ExecutionException {
        this.checkStore();
        Image image = this.imageFromPath(path);
        List<Source> sources = image.listSources();
        long totalSize = 0L;
        for (Source source : sources) {
            totalSize += source.size();
        }
        System.out.printf("Expected size %,d bytes\n", totalSize);
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList futures = new ArrayList();
        long start = System.nanoTime();
        for (Source source : sources) {
            Callable<Long> callable = () -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            };
            futures.add(executor.submit(callable));
        }
        long totalReadSize = 0L;
        for (Future future : futures) {
            totalReadSize += ((Long)future.get()).longValue();
        }
        long stop = System.nanoTime();
        System.out.printf("Read %,d bytes in %,dns (%d MBytes/second)\n", totalReadSize, stop - start, 1000L * totalReadSize / (stop - start));
        executor.shutdown();
    }

    @Command(name="listen", description="Listen for images")
    public void listen() {
        this.checkStore();
        this.store.addImageListener(new ImageListener(){

            @Override
            public void imageCreated(Image image) {
                System.out.println("Image created " + image.getMetaData().getName());
            }

            @Override
            public void imageComplete(Image image) {
                try {
                    System.out.println("Image complete " + image.getMetaData().getName());
                    List<Source> sources = image.listSources();
                    for (Source source : sources) {
                        SourceMetaData smd = source.getMetaData();
                        System.out.printf("Source location: %s length: %s\n", smd.getLocation(), Utils.humanReadableByteCount(smd.getLength()));
                    }
                }
                catch (DAQException ex) {
                    LOG.log(Level.SEVERE, "Exception in imageComplete listener", ex);
                }
            }
        });
    }

    @Command(name="read", description="Read and decode data in image")
    public void read(String path, @Argument(defaultValue=".", description="Folder where FITS files will be written") File dir, @Argument(defaultValue="1048576") int bufferSize) throws DAQException, IOException, FitsException, InterruptedException, ExecutionException {
        this.checkStore();
        Image image = this.imageFromPath(path);
        List<Source> sources = image.listSources();
        long totalSize = 0L;
        for (Source source : sources) {
            totalSize += source.size();
        }
        System.out.printf("Expected size %,d bytes\n", totalSize);
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList futures = new ArrayList();
        long start = System.nanoTime();
        for (Source source : sources) {
            Callable<Long> callable = () -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            };
            futures.add(executor.submit(callable));
        }
        long totalReadSize = 0L;
        for (Future future : futures) {
            totalReadSize += ((Long)future.get()).longValue();
        }
        long stop = System.nanoTime();
        System.out.printf("Read %,d bytes in %,dns (%d MBytes/second)\n", totalReadSize, stop - start, 1000L * totalReadSize / (stop - start));
        executor.shutdown();
    }

    @Command(name="write", description="Write a set of FITS files to the store")
    public void write(String targetFolderName, File dir, @Argument(defaultValue="*.fits") String pattern) throws IOException, TruncatedFileException, DAQException {
        this.checkStore();
        Folder target = this.store.getCatalog().find(targetFolderName);
        if (target == null) {
            throw new RuntimeException("No such folder: " + target);
        }
        final Path dirPath = dir.toPath();
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        final TreeMap obsIds = new TreeMap();
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (matcher.matches(dirPath.relativize(file))) {
                    try (BufferedFile bf = new BufferedFile(file.toFile(), "r");){
                        Header primary = new Header((ArrayDataInput)bf);
                        Header image = new Header((ArrayDataInput)bf);
                        FitsFile ff = new FitsFile(file.toFile(), primary, image);
                        FitsFile.ObsId id = (FitsFile.ObsId)obsIds.get(ff.getObsId());
                        if (id == null) {
                            id = new FitsFile.ObsId(ff.getObsId());
                            obsIds.put(ff.getObsId(), id);
                        }
                        id.add(ff);
                    }
                    catch (FitsException x) {
                        throw new IOException("Error reading FITS file: " + file, x);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        for (FitsFile.ObsId id : obsIds.values()) {
            System.out.println(id.getObsId());
            ImageMetaData meta = new ImageMetaData(id.getObsId(), "Image Annotation", 0, id.getLocations());
            Image image = target.insert(meta);
            block19: for (FitsFile.Source ffSource : id.getSources().values()) {
                System.out.println("\t" + ffSource.getLocation());
                int[] registerValues = ffSource.getFiles().first().getReadOutParameters();
                Source source = image.addSource(ffSource.getLocation(), registerValues);
                File[] files = (File[])ffSource.getFiles().stream().map(FitsFile::getFile).toArray(File[]::new);
                FitsIntReader reader = new FitsIntReader(files);
                Throwable throwable = null;
                try {
                    ByteChannel channel = source.openChannel(Source.ChannelMode.WRITE);
                    Throwable throwable2 = null;
                    try {
                        ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
                        IntBuffer intBuffer = buffer.asIntBuffer();
                        while (true) {
                            intBuffer.clear();
                            int len = reader.read(intBuffer);
                            if (len < 0) continue block19;
                            buffer.position(0);
                            buffer.limit(4 * len);
                            channel.write(buffer);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (channel == null) continue;
                        if (throwable2 != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        channel.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
    }

    @Command(name="purge", description="Purge files in a folder older than some delta to make space")
    public void purge(String folderName, String delta) throws DAQException {
        this.checkStore();
        Folder folder = this.store.getCatalog().find(folderName);
        if (folder == null) {
            throw new IllegalArgumentException("Invalid folder: " + folder);
        }
        List<Image> images = folder.listImages();
        images.sort((i1, i2) -> i1.getMetaData().getTimestamp().compareTo(i2.getMetaData().getTimestamp()));
        Instant cutOff = Instant.now().minus(Duration.parse(delta));
        for (Image image : images) {
            if (!image.getMetaData().getTimestamp().isBefore(cutOff)) break;
            System.out.println("Deleting: " + image.getMetaData().getName());
            image.delete();
        }
    }

    private Image imageFromPath(String path) throws DAQException, RuntimeException {
        Matcher matcher = PATH_PATTERN.matcher(path);
        if (!matcher.matches()) {
            throw new RuntimeException("Illegal path: " + path);
        }
        return this.imageFromPath(matcher);
    }

    private Image imageFromPath(Matcher matcher) throws DAQException {
        Folder folder = this.store.getCatalog().find(matcher.group(1));
        if (folder == null) {
            throw new RuntimeException("No such folder: " + matcher.group(1));
        }
        Image image = folder.find(matcher.group(2));
        if (image == null) {
            throw new RuntimeException("No such image: " + matcher.group(2));
        }
        return image;
    }

    private void checkStore() {
        if (this.store == null) {
            throw new RuntimeException("Please connect to store first");
        }
    }

    private String imageSize(Image image) throws DAQException {
        List<Source> sources = image.listSources();
        long totalSize = 0L;
        for (Source source : sources) {
            totalSize += source.getMetaData().getLength();
        }
        return String.format("%s(%d)", Utils.humanReadableByteCount(totalSize), sources.size());
    }

    private static /* synthetic */ File lambda$null$2(@Argument(defaultValue=".", description="Folder where FITS files will be written") File dir, Map props) {
        return new File(dir, String.format("%s_%s_%s.fits", props.get("ImageName"), props.get("RaftBay"), props.get("CCDSlot")));
    }

    static {
        HEADER_SPEC_BUILDER.addSpecFile("primary.spec");
        HEADER_SPEC_BUILDER.addSpecFile("daqv4-primary.spec", "primary");
        HEADER_SPEC_BUILDER.addSpecFile("extended.spec");
        LOG = Logger.getLogger(CommandTool.class.getName());
        PATH_PATTERN = Pattern.compile("([0-9a-zA-Z\\-\\_]*)/?([0-9a-zA-Z\\-\\_]*)");
    }
}

