/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.CRC32;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.utilities.location.Location;

public class ReadWriteStreamTest {
    private static final String TEST_FOLDER = "testFolder";
    private static final String TEST_IMAGE_NAME = "testImage";
    private static final int WRITE_BUFFER_SIZE = 0x100000;
    private static final int READ_BUFFER_SIZE = 100000;
    private static final int NBUFFERS = 27;
    private Store store;
    private Folder testFolder;
    private ByteBuffer randomData;

    @Before
    public void setUp() throws DAQException {
        Image oldImage;
        System.out.println("LD_LIBRARY_PATH=" + System.getenv("LD_LIBRARY_PATH"));
        String testPartition = System.getProperty("DAQ_TEST_PARTITION");
        System.out.println("DAQ_TEST_PARTITION=" + testPartition);
        Assume.assumeNotNull((Object[])new Object[]{testPartition});
        this.store = new Store(testPartition);
        this.testFolder = this.store.getCatalog().find(TEST_FOLDER);
        if (this.testFolder == null) {
            this.testFolder = this.store.getCatalog().insert(TEST_FOLDER);
        }
        if ((oldImage = this.testFolder.find(TEST_IMAGE_NAME)) != null) {
            oldImage.delete();
        }
        Random random = new Random(12345L);
        this.randomData = ByteBuffer.allocateDirect(0x100000);
        for (int i = 0; i < this.randomData.capacity(); ++i) {
            this.randomData.put((byte)random.nextInt(256));
        }
        this.randomData.flip();
    }

    @Test
    public void testStream() throws DAQException, IOException, InterruptedException, ExecutionException {
        final ExecutorService threadPool = Executors.newCachedThreadPool();
        final ArrayBlockingQueue futureImages = new ArrayBlockingQueue(1);
        this.store.addImageListener(new ImageListener(){

            public void imageCreated(Image image) {
                futureImages.add(threadPool.submit(new ImageStreamer(image)));
            }

            public void imageComplete(Image image) {
            }
        });
        Location location = Location.of((String)"R22/Reb1");
        int[] registerValues = new int[]{1, 2, 3, 4, 5, 6, 7};
        ImageMetaData imd = new ImageMetaData(TEST_IMAGE_NAME, "testAnnotion", 0, Collections.singleton(location));
        Image image = this.testFolder.insert(imd);
        Source source = image.addSource(location, registerValues);
        long writeLength = 0L;
        CRC32 cksum = new CRC32();
        try (ByteChannel writeChannel = source.openChannel(Source.ChannelMode.WRITE);){
            for (int i = 0; i < 27; ++i) {
                cksum.update(this.randomData);
                this.randomData.rewind();
                writeLength += (long)writeChannel.write(this.randomData);
                this.randomData.rewind();
            }
        }
        Assert.assertEquals((long)(27 * this.randomData.capacity()), (long)writeLength);
        Assert.assertEquals((long)4157543225L, (long)cksum.getValue());
        long[] result = (long[])((Future)futureImages.remove()).get();
        Assert.assertEquals((long)(27 * this.randomData.capacity()), (long)result[0]);
        Assert.assertEquals((long)cksum.getValue(), (long)result[1]);
        Assert.assertEquals((long)registerValues[0], (long)result[2]);
        Source updatedSource = image.findSource(location);
        Assert.assertEquals((long)writeLength, (long)updatedSource.getMetaData().getLength());
        Assert.assertArrayEquals((int[])registerValues, (int[])Arrays.copyOfRange(updatedSource.getMetaData().getRegisterValues(), 0, registerValues.length));
        long readLength = 0L;
        ByteBuffer readData = ByteBuffer.allocateDirect(0x100000);
        CRC32 readCksum = new CRC32();
        try (ByteChannel readChannel = updatedSource.openChannel(Source.ChannelMode.READ);){
            while (true) {
                readData.clear();
                int l = readChannel.read(readData);
                if (l < 0) {
                    break;
                }
                readData.flip();
                Assert.assertEquals((long)0L, (long)readData.position());
                Assert.assertEquals((long)0x100000L, (long)readData.limit());
                readLength += (long)l;
                readCksum.update(readData);
            }
        }
        Assert.assertEquals((long)(27 * this.randomData.capacity()), (long)readLength);
        Assert.assertEquals((long)cksum.getValue(), (long)readCksum.getValue());
    }

    private static class ImageStreamer
    implements Callable<long[]> {
        private final Image image;

        ImageStreamer(Image image) {
            this.image = image;
        }

        @Override
        public long[] call() throws IOException, DAQException {
            List sources = this.image.listSources();
            Source source = (Source)sources.get(0);
            try (ByteChannel channel = source.openChannel(Source.ChannelMode.STREAM);){
                CRC32 readCksum = new CRC32();
                ByteBuffer buffer = ByteBuffer.allocateDirect(100000);
                long totalReadSize = 0L;
                int[] registerValues = new int[]{99};
                while (true) {
                    buffer.clear();
                    int l = channel.read(buffer);
                    if (l < 0) break;
                    totalReadSize += (long)l;
                    buffer.flip();
                    readCksum.update(buffer);
                    registerValues = source.getMetaData().getRegisterValues();
                }
                long[] lArray = new long[]{totalReadSize, readCksum.getValue(), registerValues[0]};
                return lArray;
            }
        }
    }
}

