/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.Catalog;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.StreamListener;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class Store
implements AutoCloseable {
    private final Catalog catalog;
    private final String partition;
    private final long store;
    private final List<ImageListener> imageListeners = new CopyOnWriteArrayList<ImageListener>();
    private final Map<Long, Map<Integer, List<StreamListener>>> imageStreamMap = new ConcurrentHashMap<Long, Map<Integer, List<StreamListener>>>();
    private Thread imageThread;
    private static final Logger LOG = Logger.getLogger(Store.class.getName());
    private static final int IMAGE_TIMEOUT_MICROS = 0;
    private static final int SOURCE_TIMEOUT_MICROS = 10000000;

    public Store(String partition) throws DAQException {
        this.partition = partition;
        this.catalog = new Catalog(this);
        this.store = this.attachStore(partition);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getPartition() {
        return this.partition;
    }

    public long getCapacity() throws DAQException {
        return this.capacity(this.store);
    }

    public long getRemaining() throws DAQException {
        return this.remaining(this.store);
    }

    public LocationSet getConfiguredSources() throws DAQException {
        BitSet locations = this.getConfiguredSources(this.store);
        return new LocationSet(locations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener l) {
        this.imageListeners.add(l);
        Store store = this;
        synchronized (store) {
            if (this.imageThread == null) {
                this.imageThread = new Thread("ImageStreamThread_" + this.partition){

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                int rc;
                                if ((rc = Store.this.waitForImage(Store.this.store, 0, 10000000)) == 0 || rc == 68) {
                                    continue;
                                }
                                LOG.log(Level.SEVERE, "Unexpected rc from waitForImage: {0}", rc);
                            }
                        }
                        catch (Throwable x) {
                            LOG.log(Level.SEVERE, "ImageStreamThread exiting", x);
                            return;
                        }
                    }
                };
                this.imageThread.setDaemon(false);
                this.imageThread.start();
            }
        }
    }

    public void removeImageListener(ImageListener l) {
        this.imageListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageCreatedCallback(ImageMetaData meta) {
        Image image = new Image(this, meta);
        LOG.log(Level.INFO, "Image created: {0}", image);
        Map<Long, Map<Integer, List<StreamListener>>> map = this.imageStreamMap;
        synchronized (map) {
            this.imageStreamMap.put(image.getMetaData().getId(), new ConcurrentHashMap());
        }
        this.imageListeners.forEach(l -> l.imageCreated(image));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageCompleteCallback(ImageMetaData meta) {
        Map<Integer, List<StreamListener>> streamListeners;
        Image image = new Image(this, meta);
        LOG.log(Level.INFO, "Image complete: {0}", image);
        Map<Long, Map<Integer, List<StreamListener>>> map = this.imageStreamMap;
        synchronized (map) {
            streamListeners = this.imageStreamMap.remove(image.getMetaData().getId());
        }
        streamListeners.forEach((locationIndex, listeners) -> {
            try {
                SourceMetaData sourceMeta = this.findSource(meta.getId(), (int)locationIndex);
                listeners.forEach(l -> l.imageComplete(sourceMeta.getLength()));
            }
            catch (DAQException ex) {
                LOG.log(Level.SEVERE, "Exception during image complete callback", ex);
            }
        });
        this.imageListeners.forEach(l -> l.imageComplete(image));
    }

    void imageSourceStreamCallback(long imageId, int location, long length) {
        List<StreamListener> listeners;
        LOG.log(Level.FINE, "Image stream: imageId={0} location={1} length={2}", new Object[]{imageId, location, length});
        Map<Integer, List<StreamListener>> streamListeners = this.imageStreamMap.get(imageId);
        if (streamListeners != null && (listeners = streamListeners.get(location)) != null) {
            listeners.forEach(l -> l.streamLength(length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStreamListener(long imageId, int location, StreamListener listener) {
        Map<Integer, List<StreamListener>> streamListeners;
        Map<Long, Map<Integer, List<StreamListener>>> map = this.imageStreamMap;
        synchronized (map) {
            streamListeners = this.imageStreamMap.get(imageId);
        }
        if (streamListeners == null) {
            try {
                SourceMetaData sourceMeta = this.findSource(imageId, location);
                listener.imageComplete(sourceMeta.getLength());
            }
            catch (DAQException ex) {
                LOG.log(Level.SEVERE, "Unexpected exception while adding stream listener", ex);
            }
        } else {
            List<StreamListener> listeners = streamListeners.get(location);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<StreamListener>();
                streamListeners.put(location, listeners);
            }
            listeners.add(listener);
        }
    }

    void removeStreamListener(long imageId, int location, StreamListener listener) {
        List<StreamListener> listeners;
        Map<Integer, List<StreamListener>> streamListeners = this.imageStreamMap.get(imageId);
        if (streamListeners != null && (listeners = streamListeners.get(location)) != null) {
            listeners.remove(listener);
        }
    }

    @Override
    public void close() throws DAQException {
        this.detachStore(this.store);
    }

    List<String> listFolders() throws DAQException {
        ArrayList<String> result = new ArrayList<String>();
        this.listFolders(this.store, result);
        return result;
    }

    int insertFolder(String folderName) throws DAQException {
        return this.insertFolder(this.store, folderName);
    }

    int removeFolder(String folderName) throws DAQException {
        return this.removeFolder(this.store, folderName);
    }

    boolean findFolder(String folderName) throws DAQException {
        return this.findFolder(this.store, folderName);
    }

    void listImages(String folderName, List<ImageMetaData> result) throws DAQException {
        this.listImages(this.store, folderName, result);
    }

    int moveImageToFolder(long id, String folderName) throws DAQException {
        return this.moveImageToFolder(this.store, id, folderName);
    }

    int deleteImage(long id) throws DAQException {
        return this.deleteImage(this.store, id);
    }

    SourceMetaData findSource(long id, int location) throws DAQException {
        return this.findSource(this.store, id, location);
    }

    ImageMetaData addImageToFolder(String imageName, String folderName, ImageMetaData meta) throws DAQException {
        return this.addImageToFolder(this.store, imageName, folderName, meta.getAnnotation(), meta.getOpcode(), meta.getLocationBitSet());
    }

    ImageMetaData findImage(String imageName, String folderName) throws DAQException {
        return this.findImage(this.store, imageName, folderName);
    }

    long openSourceChannel(long id, Location location, Source.ChannelMode mode) throws DAQException {
        return this.openSourceChannel(this.store, id, location.index(), mode == Source.ChannelMode.WRITE);
    }

    SourceMetaData addSourceToImage(long id, Location location, int[] registerValues) throws DAQException {
        return this.addSourceToImage(this.store, id, location.index(), (byte)location.type().getCCDCount(), "test-platform", registerValues);
    }

    private synchronized native long attachStore(String var1) throws DAQException;

    private synchronized native void detachStore(long var1) throws DAQException;

    private synchronized native long capacity(long var1) throws DAQException;

    private synchronized native long remaining(long var1) throws DAQException;

    private synchronized native void listFolders(long var1, List<String> var3) throws DAQException;

    private synchronized native int insertFolder(long var1, String var3) throws DAQException;

    private synchronized native int removeFolder(long var1, String var3) throws DAQException;

    private synchronized native boolean findFolder(long var1, String var3) throws DAQException;

    private synchronized native void listImages(long var1, String var3, List<ImageMetaData> var4) throws DAQException;

    private synchronized native int moveImageToFolder(long var1, long var3, String var5) throws DAQException;

    private synchronized native int deleteImage(long var1, long var3) throws DAQException;

    private synchronized native SourceMetaData findSource(long var1, long var3, int var5) throws DAQException;

    private synchronized native ImageMetaData addImageToFolder(long var1, String var3, String var4, String var5, int var6, BitSet var7) throws DAQException;

    private synchronized native ImageMetaData findImage(long var1, String var3, String var4) throws DAQException;

    private synchronized native long openSourceChannel(long var1, long var3, int var5, boolean var6) throws DAQException;

    private synchronized native SourceMetaData addSourceToImage(long var1, long var3, int var5, byte var6, String var7, int[] var8) throws DAQException;

    private native int waitForImage(long var1, int var3, int var4) throws DAQException;

    static native String decodeException(int var0);

    private synchronized native BitSet getConfiguredSources(long var1) throws DAQException;

    static {
        System.loadLibrary("ccs_daq_ims");
    }
}

