/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import java.nio.IntBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.daq.ims.channel.Compress18BitChannel;
import org.lsst.ccs.daq.ims.channel.Decompress18BitChannel;
import org.lsst.ccs.daq.ims.channel.DemultiplexingIntChannel;
import org.lsst.ccs.daq.ims.channel.IntBufferReader;
import org.lsst.ccs.daq.ims.channel.IntBufferWriter;
import org.lsst.ccs.daq.ims.channel.MultiplexingIntChannel;
import org.lsst.ccs.daq.ims.channel.ReadableIntChannel;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;

public class Compress18BitChannelTest {
    @Test
    public void testDecompressCompress() throws IOException {
        Throwable throwable;
        int[] data = new int[]{65536, 131072, 196608, 4, 5, 6, 7, 8, 9};
        IntBuffer input = IntBuffer.wrap(data);
        IntBuffer output1 = IntBuffer.allocate(8);
        IntBuffer output2 = IntBuffer.allocate(8);
        try (DemultiplexingIntChannel destination = new DemultiplexingIntChannel(new WritableIntChannel[]{new IntBufferWriter(output1), new IntBufferWriter(output2)});){
            throwable = null;
            try (Decompress18BitChannel b18 = new Decompress18BitChannel((WritableIntChannel)destination);){
                b18.write(input);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        Assert.assertEquals((long)8L, (long)output1.position());
        Assert.assertEquals((long)8L, (long)output2.position());
        output1.flip();
        output2.flip();
        var6_6 = null;
        try (MultiplexingIntChannel multi = new MultiplexingIntChannel(new ReadableIntChannel[]{new IntBufferReader(output1), new IntBufferReader(output2)});){
            throwable = null;
            try (Compress18BitChannel compress = new Compress18BitChannel((ReadableIntChannel)multi);){
                int[] result = new int[data.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = compress.read();
                }
                Assert.assertArrayEquals((int[])data, (int[])result);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var6_6 = throwable4;
            throw throwable4;
        }
    }
}

