/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.channel.Decompress18BitChannel;
import org.lsst.ccs.daq.ims.channel.DemultiplexingIntChannel;
import org.lsst.ccs.daq.ims.channel.FitsAsyncWriteChannel;
import org.lsst.ccs.daq.ims.channel.ReadoutConfig;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;
import org.lsst.ccs.daq.ims.channel.XORWritableIntChannel;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.readout.GeometryFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.readout.PropertiesFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.readout.ReadOutImageSet;
import org.lsst.ccs.utilities.readout.ReadOutParameters;
import org.lsst.ccs.utilities.readout.ReadOutParametersBuilder;
import org.lsst.ccs.utilities.readout.ReadOutParametersNew;

public class FitsIntWriter
implements WritableIntChannel {
    private static final DateTimeFormatter DATE_FORMAT;
    private final Decompress18BitChannel decompress;
    private final FitsFileWriter[] writers;
    private final File[] files;

    public FitsIntWriter(Source source, Reb reb, Map<String, HeaderSpecification> headerSpecifications, FileNamer fileNamer, PerCCDMetaDataProvider extraMetaDataProvider) throws DAQException, IOException {
        int ccdCount = source.getSourceType().getCCDCount();
        SourceMetaData smd = source.getMetaData();
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            ImageName in = new ImageName(source.getImage().getMetaData().getName());
            props.put("ImageName", in.toString());
            props.put("ImageDate", in.getDateString());
            props.put("ImageNumber", in.getNumberString());
            props.put("ImageController", in.getController().getCode());
            props.put("ImageSource", in.getSource().getCode());
        }
        catch (IllegalArgumentException x) {
            props.put("ImageName", source.getImage().getMetaData().getName());
            props.put("ImageDate", DATE_FORMAT.format(source.getImage().getMetaData().getTimestamp()));
        }
        props.put("FileCreationTime", new Date());
        props.put("DAQTriggerTime", source.getImage().getMetaData().getTimestamp());
        props.put("Tag", String.format("%x", source.getImage().getMetaData().getId()));
        props.put("RaftBay", source.getLocation().getRaftName());
        props.put("RebSlot", source.getLocation().getBoardName());
        props.put("Firmware", String.format("%x", smd.getFirmware()));
        props.put("Platform", smd.getPlatform());
        props.put("CCDControllerSerial", String.format("%x", smd.getSerialNumber() & 0xFFFFFFFFL));
        props.put("DAQVersion", smd.getSoftware().toString());
        props.put("DAQPartition", source.getImage().getStore().getPartition());
        props.put("DAQFolder", source.getImage().getMetaData().getCreationFolderName());
        props.put("DAQAnnotation", source.getImage().getMetaData().getAnnotation());
        int[] registerValues = smd.getRegisterValues();
        ReadOutParametersBuilder builder = ReadOutParametersBuilder.create();
        builder.readoutParameterValues(registerValues);
        builder.readoutParameterNames(ReadOutParametersNew.DEFAULT_NAMES);
        ReadOutParameters readoutParameters = builder.build();
        if (source.getSourceType() == Location.LocationType.SCIENCE) {
            reb.setCCDType(readoutParameters.getCCDType());
        }
        this.files = new File[source.getSourceType() == Location.LocationType.WAVEFRONT ? 2 : ccdCount];
        this.writers = new FitsFileWriter[this.files.length];
        ReadoutConfig readoutConfig = new ReadoutConfig(source.getSourceType());
        WritableIntChannel[] fileChannels = new WritableIntChannel[ccdCount * 16];
        try {
            for (int i = 0; i < this.files.length; ++i) {
                int n = readoutConfig.getDataSensorMap()[i];
                HashMap<String, Object> ccdProps = new HashMap<String, Object>();
                ccdProps.putAll(props);
                ccdProps.put("CCDSlot", source.getLocation().getSensorName(n));
                this.files[i] = fileNamer.computeFileName(ccdProps);
                PropertiesFitsHeaderMetadataProvider propsFitsHeaderMetadataProvider = new PropertiesFitsHeaderMetadataProvider(ccdProps);
                CCD cCD = (CCD)reb.getCCDs().get(n);
                if (!cCD.getName().equals(ccdProps.get("CCDSlot"))) {
                    throw new IOException(String.format("Geometry (%s) inconsistent with DAQ location (%s)", cCD.getName(), ccdProps.get("CCDSlot")));
                }
                ReadOutImageSet imageSet = new ReadOutImageSet(Arrays.asList(readoutConfig.getDataSegmentNames()), readoutParameters);
                ArrayList<Object> providers = new ArrayList<Object>();
                providers.add(new GeometryFitsHeaderMetadataProvider(cCD));
                providers.add(propsFitsHeaderMetadataProvider);
                if (extraMetaDataProvider != null) {
                    providers.addAll(extraMetaDataProvider.getMetaDataProvider(cCD));
                }
                this.writers[i] = new FitsFileWriter(this.files[i], (ImageSet)imageSet, headerSpecifications, providers);
                int nImageExtensions = imageSet.getImageExtensionNames().size();
                for (int j = 0; j < nImageExtensions; ++j) {
                    fileChannels[i * nImageExtensions + j] = new FitsAsyncWriteChannel(this.writers[i], readoutConfig.getDataSegmentNames()[readoutConfig.getDataSegmentMap()[j]]);
                }
            }
            DemultiplexingIntChannel demultiplex = new DemultiplexingIntChannel(fileChannels);
            XORWritableIntChannel xORWritableIntChannel = new XORWritableIntChannel(demultiplex, readoutConfig.getXor());
            this.decompress = new Decompress18BitChannel(xORWritableIntChannel);
        }
        catch (IOException | RuntimeException | FitsException t) {
            for (FitsFileWriter fitsFileWriter : this.writers) {
                if (fitsFileWriter == null) continue;
                try {
                    fitsFileWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (File file : this.files) {
                if (file == null) continue;
                file.delete();
            }
            throw t instanceof IOException ? (IOException)t : new IOException("Error writing FITS files for source " + source, t);
        }
    }

    @Override
    public void write(int i) throws IOException {
        this.decompress.write(i);
    }

    @Override
    public void write(IntBuffer buffer) throws IOException {
        this.decompress.write(buffer);
    }

    @Override
    public boolean isOpen() {
        return this.decompress.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.decompress.close();
        for (FitsFileWriter writer : this.writers) {
            if (writer == null) continue;
            writer.close();
        }
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(Arrays.asList(this.files));
    }

    static {
        FitsFactory.setUseHierarch((boolean)true);
        DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    }

    public static interface PerCCDMetaDataProvider {
        public List<FitsHeaderMetadataProvider> getMetaDataProvider(CCD var1);
    }

    public static interface FileNamer {
        public File computeFileName(Map<String, Object> var1);
    }
}

