/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;
import org.lsst.ccs.utilities.image.FitsFileWriter;

public class FitsWriteChannel
implements WritableIntChannel {
    ByteBuffer currentBuffer;
    final int segment;
    final FitsFileWriter writer;
    boolean isOpen = true;

    public FitsWriteChannel(FitsFileWriter writer, int segment) {
        this.writer = writer;
        this.segment = segment;
        this.currentBuffer = ByteBuffer.allocateDirect(1000000);
        this.currentBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void write(int i) throws IOException {
        if (this.currentBuffer.remaining() < 4) {
            this.flush();
        }
        this.currentBuffer.putInt(i);
    }

    @Override
    public void write(IntBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            IntBuffer asIntBuffer = this.currentBuffer.asIntBuffer();
            if (buffer.remaining() < asIntBuffer.remaining()) {
                asIntBuffer.put(buffer);
                this.currentBuffer.position(this.currentBuffer.position() + asIntBuffer.position());
            } else {
                int oldLimit = buffer.limit();
                buffer.limit(buffer.position() + asIntBuffer.remaining());
                asIntBuffer.put(buffer);
                this.currentBuffer.position(this.currentBuffer.position() + asIntBuffer.position());
                buffer.limit(oldLimit);
            }
            if (this.currentBuffer.remaining() != 0) continue;
            this.flush();
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen) {
            this.flush();
            this.isOpen = false;
        }
    }

    void flush() throws IOException {
        this.currentBuffer.flip();
        this.writer.write(this.segment, this.currentBuffer);
        this.currentBuffer.clear();
    }
}

