#! /bin/bash


#Implementation as suggested in LSSTCCS-130
osType=`uname`
if [ "$osType" == "Linux" ]
then 
    scriptFullPath=`readlink -fn $0` 
else 
    scriptFullPath=`perl -e "use Cwd 'abs_path'; print abs_path('$0')"`
fi 

# To find the full path of the script CD into the dir containing the script
binDir=$(cd "$(dirname "$scriptFullPath")"; pwd -P)

distDir=`dirname $binDir`

mainJar=$distDir/share/java/org-lsst-ccs-bootstrap-1.0.4.jar

export LD_LIBRARY_PATH=`java -cp $mainJar org.lsst.ccs.bootstrap.BootstrapEnvironmentUtils "LD_LIBRARY_PATH"`

java -Djava.system.class.loader=org.lsst.ccs.bootstrap.BootstrapClassLoader  $CCS_JAVA_OPTS -jar $mainJar "$@"
