/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.cryogenic;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;
import org.lsst.ccs.utilities.logging.Logger;

public class TempControl24C {
    Logger log = Logger.getLogger((String)"lsst.drivers.cryogenic");
    private static final int DEFAULT_TYPE = 0;
    private static final int DEFAULT_PORT = 5000;
    private static final String BNL_DEFAULT_IP = "192.168.2.198";
    private Scpi scpi = new Scpi();

    public TempControl24C() throws DriverException {
    }

    public TempControl24C(int type, String ident, int param) throws DriverException {
        this.open(type, ident, param);
    }

    public void open(int type, String ident, int param) throws DriverException {
        this.scpi.open(type, ident, param);
        this.log.debug((Object)"Opened Cryogenic Temperature Controller", new String[0]);
    }

    public void openDefault() throws DriverException {
        this.open(0, BNL_DEFAULT_IP, 5000);
    }

    public void close() throws DriverException {
        this.scpi.close();
    }

    public String[] getIdentification() throws DriverException {
        String[] id = this.scpi.getIdentification();
        return id;
    }

    public double getMaxSetPoint(int loop) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("TempControl24C::getMaxSetPoint loop is invalid " + loop);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":MAXSET?";
        String resp = this.scpi.read(cmd);
        return Double.parseDouble(resp);
    }

    public void setMaxSetPoint(int loop, double temp) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("TempControl24C::setMaxSetPoint loop is invalid " + loop);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":MAXSET " + Double.toString(temp) + ";:*OPC?";
        String resp = this.scpi.read(cmd);
        int retVal = Integer.parseInt(resp);
        if (retVal != 1) {
            throw new DriverException("TempControl24C::setMaxSetPoint returned error code " + resp);
        }
    }

    public double getSetPoint(int loop) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("TempControl24C::getSetPoint loop is invalid " + loop);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":SETPT?";
        String resp = this.scpi.read(cmd);
        return Double.parseDouble(resp);
    }

    public void setSetPoint(int loop, double temp) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("TempControl24C::setSetPoint loop is invalid " + loop);
        }
        if (temp > this.getMaxSetPoint(loop)) {
            throw new DriverException("TempControl24C::setSetPoint requested temp is too high check MAXSET " + temp);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":SETPT " + Double.toString(temp) + ";:*OPC?";
        String resp = this.scpi.read(cmd);
        int retVal = Integer.parseInt(resp);
        if (retVal != 1) {
            throw new DriverException("TempControl24C::setSetPoint returned error code " + resp);
        }
    }

    public String getSource(int loop) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("TempControl24C::getSource loop is invalid " + loop);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":SOURCE?";
        String resp = this.scpi.read(cmd);
        if (resp.charAt(0) >= 'A' && resp.charAt(0) <= 'D') {
            return resp;
        }
        throw new DriverException("TempControl24C::getSource invalid response " + resp);
    }

    public void setSource(int loop, char channel) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("TempControl24C::setSource loop is invalid " + loop);
        }
        if (channel >= 'A' && channel <= 'D') {
            String cmd = "LOOP " + Integer.toString(loop) + ":SOURCE " + channel + ";:*OPC?";
            String resp = this.scpi.read(cmd);
            int retVal = Integer.parseInt(resp);
            if (retVal != 1) {
                throw new DriverException("TempControl24C::setSource returned error code " + resp);
            }
            return;
        }
        throw new DriverException("TempControl24C::setSource channel is invalid " + channel);
    }

    public double getTemp(char channel) throws DriverException {
        if (channel >= 'A' && channel <= 'D') {
            String cmd = "INPUT " + channel + ":TEMP?";
            return this.scpi.readDouble(cmd);
        }
        throw new DriverException("Invalid channel request " + channel);
    }

    public char getUnit(char channel) throws DriverException {
        char upperCh = Character.toUpperCase(channel);
        if (upperCh >= 'A' && upperCh <= 'D') {
            String cmd = "INPUT " + upperCh + ":UNIT?";
            String resp = this.scpi.read(cmd);
            if (!resp.matches("[K|C|F|S]")) {
                throw new DriverException("Invalid response for UNIT?" + resp);
            }
            return resp.charAt(0);
        }
        throw new DriverException("Invalid channel request " + channel);
    }

    public void setUnit(char channel, char unit) throws DriverException {
        Character upperCh = Character.valueOf(Character.toUpperCase(channel));
        Character upperUn = Character.valueOf(Character.toUpperCase(unit));
        if (upperCh.charValue() >= 'A' && upperCh.charValue() <= 'D') {
            if (!upperUn.toString().matches("[K|C|F|S]")) {
                throw new DriverException("Invalid Unit request " + unit);
            }
            String cmd = "INPUT " + upperCh.charValue() + ":UNITS " + upperUn.charValue() + ";:*OPC?";
            String resp = this.scpi.read(cmd);
            int retVal = Integer.parseInt(resp);
            if (retVal != 1) {
                throw new DriverException("Invalid response for UNIT?" + resp);
            }
            return;
        }
        throw new DriverException("Invalid channel request " + channel);
    }
}

