/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.cryocon;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.cryocon.M24C;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestM24C
extends TestScpi {
    private static final DriverConstants.ConnType DEFAULT_TYPE = DriverConstants.ConnType.NET;
    private static final String BNL_DEFAULT_IP = "192.168.2.198";
    private final M24C m24c;

    public TestM24C() {
        super(new M24C());
        this.m24c = (M24C)this.scpi;
    }

    @Command(description="Open network connection to Model 24C")
    public void open(@Argument(description="Host name") String host) throws DriverException {
        this.m24c.open(DEFAULT_TYPE, host, 0);
    }

    @Command(description="Open connection to Model 24C")
    public void open(@Argument(description="Communications type") DriverConstants.ConnType type, @Argument(description="Device identifier") String ident) throws DriverException {
        this.m24c.open(type, ident, 0);
    }

    @Command(description="Open connection to BNL default Model 24C")
    public void openBNLDefault() throws DriverException {
        this.m24c.open(DEFAULT_TYPE, BNL_DEFAULT_IP, 0);
    }

    @Command(description="Retrieve MaxSetPoint for loop")
    public double getMaxSetPoint(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getMaxSetPoint(loop);
    }

    @Command(description="setMaxSetPoint for loop")
    public void setMaxSetPoint(@Argument(description="loop number [1-4]") int loop, @Argument(description="temperature") double temp) throws DriverException {
        this.m24c.setMaxSetPoint(loop, temp);
    }

    @Command(description="Retrieve setPoint for loop")
    public double getSetPoint(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSetPoint(loop);
    }

    @Command(description="setSetPoint for loop")
    public void setSetPoint(@Argument(description="loop number [1-4]") int loop, @Argument(description="temperature") double temp) throws DriverException {
        this.m24c.setSetPoint(loop, temp);
    }

    @Command(description="Retrieve PID P value for loop")
    public double getPidP(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPidP(loop);
    }

    @Command(description="Set PID P value for loop")
    public void setPidP(@Argument(description="loop number [1-4]") int loop, @Argument(description="PID P value") double pValue) throws DriverException {
        this.m24c.setPidP(loop, pValue);
    }

    @Command(description="Retrieve PID I value for loop")
    public double getPidI(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPidI(loop);
    }

    @Command(description="Set PID I value for loop")
    public void setPidI(@Argument(description="loop number [1-4]") int loop, @Argument(description="PID I value") double iValue) throws DriverException {
        this.m24c.setPidI(loop, iValue);
    }

    @Command(description="Retrieve PID D value for loop")
    public double getPidD(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPidD(loop);
    }

    @Command(description="Set PID D value for loop")
    public void setPidD(@Argument(description="loop number [1-4]") int loop, @Argument(description="PID D value") double dValue) throws DriverException {
        this.m24c.setPidD(loop, dValue);
    }

    @Command(description="Retrieve source channel for loop")
    public char getLoopSource(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSource(loop);
    }

    @Command(description="Set source channel for loop")
    public void setLoopSource(@Argument(description="loop number [1-4]") int loop, @Argument(description="channel [A-D]") String channel) throws DriverException {
        this.m24c.setSource(loop, TestM24C.stringToChar(channel));
    }

    @Command(description="Retrieve heater range for loop")
    public String getHeaterRange(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterRange(loop);
    }

    @Command(description="Set heater range for loop")
    public void setHeaterRange(@Argument(description="loop number [1-4]") int loop, @Argument(description="range (lo, mid or hi)") String range) throws DriverException {
        this.m24c.setHeaterRange(loop, range);
    }

    @Command(description="Retrieve maximum heater power for loop")
    public double getHeaterMax(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterMax(loop);
    }

    @Command(description="Set maximum heater power for loop")
    public void setHeaterMax(@Argument(description="loop number [1-4]") int loop, @Argument(description="maximum power (%)") double power) throws DriverException {
        this.m24c.setHeaterMax(loop, power);
    }

    @Command(description="Retrieve manual heater power for loop")
    public double getHeaterPower(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterPower(loop);
    }

    @Command(description="Set manual heater power for loop")
    public void setHeaterPower(@Argument(description="loop number [1-4]") int loop, @Argument(description="manual power (%)") double power) throws DriverException {
        this.m24c.setHeaterPower(loop, power);
    }

    @Command(description="Retrieve control type for loop")
    public String getControlType(@Argument(description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getControlType(loop);
    }

    @Command(description="Set control type for loop")
    public void setControlType(@Argument(description="loop number [1-4]") int loop, @Argument(description="control type string") String type) throws DriverException {
        this.m24c.setControlType(loop, type);
    }

    @Command(description="Retrieve temperature")
    public double getTemp(@Argument(description="Temp Channel to read") String channel) throws DriverException {
        return this.m24c.getTemp(TestM24C.stringToChar(channel));
    }

    @Command(description="Retrieve temperature units")
    public char getUnit(@Argument(description="Temp Channel to read") String channel) throws DriverException {
        return this.m24c.getUnit(TestM24C.stringToChar(channel));
    }

    @Command(description="Set temperature units")
    public void setUnit(@Argument(description="Temp Channel to set") String channel, @Argument(description="Units in [K|C|F|S]") String unit) throws DriverException {
        this.m24c.setUnit(TestM24C.stringToChar(channel), TestM24C.stringToChar(unit));
    }

    @Command(description="Get sensor type")
    public String getType(@Argument(description="Channel ID") String channel) throws DriverException {
        return this.m24c.getType(TestM24C.stringToChar(channel));
    }

    @Command(description="Set sensor type")
    public void setType(@Argument(description="Channel ID") String channel, @Argument(description="Sensor type") String type) throws DriverException {
        this.m24c.setType(TestM24C.stringToChar(channel), type);
    }

    @Command(description="Get whether OTD system enabled")
    public boolean isOtdEnabled() throws DriverException {
        return this.m24c.isOtdEnabled();
    }

    @Command(description="Set OTD system enabled state")
    public void enableOtd(@Argument(description="Whether to enable OTD system") boolean enab) throws DriverException {
        this.m24c.enableOtd(enab);
    }

    @Command(description="Get source channel for the OTD system")
    public char getOtdSource() throws DriverException {
        return this.m24c.getOtdSource();
    }

    @Command(description="Set source channel for the OTD system")
    public void setOtdSource(@Argument(description="channel [A-D]") String channel) throws DriverException {
        this.m24c.setOtdSource(TestM24C.stringToChar(channel));
    }

    @Command(description="Get temperature limit for the OTD system")
    public double getOtdTemp() throws DriverException {
        return this.m24c.getOtdTemp();
    }

    @Command(description="Set temperature limit for the OTD system")
    public void setOtdTemp(@Argument(description="Temperature") double temp) throws DriverException {
        this.m24c.setOtdTemp(temp);
    }

    @Command(description="Get whether control is on")
    public boolean isInControl() throws DriverException {
        return this.m24c.isInControl();
    }

    @Command(description="Get control state")
    public String getControl() throws DriverException {
        return this.m24c.getControl();
    }

    @Command(description="Set control on")
    public void setToControl() throws DriverException {
        this.m24c.setToControl();
    }

    @Command(description="Set control off")
    public void stopControl() throws DriverException {
        this.m24c.stopControl();
    }

    private static char stringToChar(String str) throws DriverException {
        if (str.length() != 1) {
            throw new DriverException("String must be of length 1");
        }
        return str.charAt(0);
    }
}

