/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.cryocon;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.cryocon.M24C;
import org.lsst.ccs.drivers.scpi.Scpi;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestM24C
extends TestScpi {
    private final M24C tempDev;

    public TestM24C() {
        super((Scpi)new M24C());
        this.tempDev = (M24C)this.scpi;
    }

    @Command(name="open", description="Open connection to Model 24C")
    public void open(@Argument(name="type", description="Communications type") DriverConstants.ConnType type, @Argument(name="identity", description="Device identifier") String ident) throws DriverException {
        this.tempDev.open(type, ident, 0);
    }

    @Command(name="openDefault", description="Open connection to Default Model 24C")
    public void openDefault() throws DriverException {
        this.tempDev.openDefault();
    }

    @Command(name="getMaxSetPoint", description="Retrieve MaxSetPoint for loop")
    public double getMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.tempDev.getMaxSetPoint(loop);
    }

    @Command(name="setMaxSetPoint", description="setMaxSetPoint for loop")
    public void setMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        this.tempDev.setMaxSetPoint(loop, temp);
    }

    @Command(name="getSetPoint", description="Retrieve setPoint for loop")
    public double getSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.tempDev.getSetPoint(loop);
    }

    @Command(name="setSetPoint", description="setSetPoint for loop")
    public void setSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        this.tempDev.setSetPoint(loop, temp);
    }

    @Command(name="getLoopSource", description="Retrieve source channel for loop")
    public char getLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.tempDev.getSource(loop).charAt(0);
    }

    @Command(name="setLoopSource", description="Set source channel for loop")
    public void setLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="channel", description="channel [A-D]") String channel) throws DriverException {
        this.tempDev.setSource(loop, TestM24C.stringToChar(channel));
    }

    @Command(name="getTemp", description="Retrieve temperature")
    public double getTemp(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        return this.tempDev.getTemp(TestM24C.stringToChar(channel));
    }

    @Command(name="getUnit", description="Retrieve temperature units")
    public char getUnit(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        return this.tempDev.getUnit(TestM24C.stringToChar(channel));
    }

    @Command(name="setUnit", description="Set temperature units")
    public void setUnit(@Argument(name="channel", description="Temp Channel to set") String channel, @Argument(name="units", description="Units in [K|C|F|S]") String unit) throws DriverException {
        this.tempDev.setUnit(TestM24C.stringToChar(channel), TestM24C.stringToChar(unit));
    }

    @Command(name="getType", description="Get sensor type")
    public String getType(@Argument(name="channel", description="Channel ID") String channel) throws DriverException {
        return this.tempDev.getType(TestM24C.stringToChar(channel));
    }

    @Command(name="setType", description="Set sensor type")
    public void setType(@Argument(name="channel", description="Channel ID") String channel, @Argument(name="type", description="Sensor type") String type) throws DriverException {
        this.tempDev.setType(TestM24C.stringToChar(channel), type);
    }

    @Command(name="isControl", description="Get whether control is on")
    public boolean isControl() throws DriverException {
        return this.tempDev.isInControl();
    }

    @Command(name="control", description="Set control on")
    public void control() throws DriverException {
        this.tempDev.setToControl();
    }

    private static char stringToChar(String str) throws DriverException {
        if (str.length() != 1) {
            throw new DriverException("String must be of length 1");
        }
        return str.charAt(0);
    }
}

