/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.cryocon;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;
import org.lsst.ccs.utilities.logging.Logger;

public class M24C
extends Scpi {
    public static final int NUM_LOOPS = 4;
    private static final int DEFAULT_PORT = 5000;
    private static final int DEFAULT_BAUD = 9600;
    private static final DriverConstants.ConnType DEFAULT_TYPE = DriverConstants.ConnType.NET;
    private static final String BNL_DEFAULT_IP = "192.168.2.198";
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private final Map<Integer, String> invTypeMap = new HashMap<Integer, String>();
    private final Logger log = Logger.getLogger((String)"lsst.ccs.drivers.cryocon");

    public M24C() {
        for (String type : typeMap.keySet()) {
            this.invTypeMap.put(typeMap.get(type), type);
        }
    }

    @Deprecated
    public M24C(int type, String ident, int param) throws DriverException {
        this();
        this.open(type, ident, param);
    }

    public void open(DriverConstants.ConnType type, String ident, int parm1, int parm2) throws DriverException {
        super.open(type, ident, parm1 == 0 ? (type == DriverConstants.ConnType.NET ? 5000 : 9600) : parm1, parm2);
        try {
            this.checkIdentification("Cryo-con", 0, "24C", 3);
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
        this.log.debug((Object)"Opened Cryo-con M24C temperature controller");
    }

    public void openDefault() throws DriverException {
        this.open(DEFAULT_TYPE, BNL_DEFAULT_IP, 5000);
    }

    public double getMaxSetPoint(int loop) throws DriverException {
        this.checkLoop(loop);
        return Double.parseDouble(this.readString("LOOP " + loop + ":MAXSET?").replaceAll("[a-zA-Z]", ""));
    }

    public void setMaxSetPoint(int loop, double temp) throws DriverException {
        this.checkLoop(loop);
        this.writeCommand("LOOP " + loop + ":MAXSET " + temp);
    }

    public double getSetPoint(int loop) throws DriverException {
        this.checkLoop(loop);
        return Double.parseDouble(this.readString("LOOP " + loop + ":SETPT?").replaceAll("[a-zA-Z]", ""));
    }

    public void setSetPoint(int loop, double temp) throws DriverException {
        this.checkLoop(loop);
        if (temp > this.getMaxSetPoint(loop)) {
            throw new DriverException("Temperature is above maximum set point: " + temp);
        }
        this.writeCommand("LOOP " + loop + ":SETPT " + temp);
    }

    public double getHtrRead(int loop) throws DriverException {
        this.checkLoop(loop);
        return Double.parseDouble(this.readString("LOOP " + loop + ":HTRR?").replace("%", ""));
    }

    public double getPID_P(int loop) throws DriverException {
        this.checkLoop(loop);
        return this.readDouble("LOOP " + loop + ":PGAIN?");
    }

    public double getPID_I(int loop) throws DriverException {
        this.checkLoop(loop);
        return this.readDouble("LOOP " + loop + ":IGAIN?");
    }

    public double getPID_D(int loop) throws DriverException {
        this.checkLoop(loop);
        return this.readDouble("LOOP " + loop + ":DGAIN?");
    }

    public String getSource(int loop) throws DriverException {
        this.checkLoop(loop);
        String resp = this.readString("LOOP " + loop + ":SOURCE?");
        if (resp.charAt(0) >= 'A' && resp.charAt(0) <= 'D') {
            return resp;
        }
        throw new DriverException("Invalid source response: " + resp);
    }

    public void setSource(int loop, char channel) throws DriverException {
        this.checkLoop(loop);
        this.checkChannel(channel);
        this.writeCommand("LOOP " + loop + ":SOURCE " + channel);
    }

    public void setHeaterRange(int loop, String range) throws DriverException {
        this.checkLoop(loop);
        String urange = range.toUpperCase();
        if (!urange.matches("HI|MID|LOW")) {
            throw new DriverException("Invalid range: " + range + " - must be HI, MID or LOW");
        }
        this.writeCommand("LOOP " + loop + ":RANGE " + range);
    }

    public double getTemp(char channel) throws DriverException {
        double temp = -999.0;
        this.checkChannel(channel);
        String resp = this.readString("INPUT " + channel + ":TEMP?");
        if (resp.matches("\\.+|-+| +")) {
            this.log.debug((Object)("CryoCon channel " + channel + " appears not to be connected."));
        } else {
            temp = Double.parseDouble(resp.replaceAll("[a-zA-Z]", ""));
        }
        return temp;
    }

    public char getUnit(char channel) throws DriverException {
        this.checkChannel(channel);
        return this.readString("INPUT " + channel + ":UNIT?").charAt(0);
    }

    public void setUnit(char channel, char unit) throws DriverException {
        this.checkChannel(channel);
        if (!String.valueOf(unit).toUpperCase().matches("[K|C|F|S]")) {
            throw new DriverException("Invalid unit value: " + unit);
        }
        this.writeCommand("INPUT " + channel + ":UNITS " + unit);
    }

    public String getType(char channel) throws DriverException {
        this.checkChannel(channel);
        String type = this.invTypeMap.get(this.readInteger("INPUT " + channel + ":SENS?"));
        return type == null ? "UNKNOWN" : type;
    }

    public void setType(char channel, String typ) throws DriverException {
        this.checkChannel(channel);
        Integer ityp = typeMap.get(typ.toUpperCase());
        if (ityp == null) {
            throw new DriverException("Invalid sensor type: " + typ);
        }
        this.writeCommand("INPUT " + channel + ":SENSOR " + ityp);
    }

    public void setToControl() throws DriverException {
        this.writeCommand("CONTROL");
    }

    public boolean isInControl() throws DriverException {
        return this.readString("CONTROL?").contains("ON");
    }

    public String readString(String cmnd) throws DriverException {
        String resp = this.read(cmnd);
        if (resp.equals("NAK")) {
            throw new DriverException("Can't execute command: \"" + cmnd + "\"");
        }
        return resp;
    }

    public void writeCommand(String cmnd) throws DriverException {
        if (this.read(cmnd + ";:*OPC?").equals("NAK")) {
            throw new DriverException("Can't execute command: \"" + cmnd + "\"");
        }
    }

    private void checkLoop(int loop) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("Invalid loop number: " + loop);
        }
    }

    private void checkChannel(char chan) throws DriverException {
        char uchan = Character.toUpperCase(chan);
        if (uchan < 'A' || uchan > 'D') {
            throw new DriverException("Invalid channel: " + chan);
        }
    }

    static {
        typeMap.put("DIODE", 5);
        typeMap.put("PTC100", 20);
        typeMap.put("PTC1K", 21);
        typeMap.put("NONE", 0);
        typeMap.put("INTERNAL", 59);
        typeMap.put("DIODE1", 1);
        typeMap.put("DIODE2", 2);
        typeMap.put("DIODE3", 3);
        typeMap.put("DIODE4", 4);
        typeMap.put("TC70K", 45);
        typeMap.put("TC70E", 46);
        typeMap.put("TC70T", 47);
        typeMap.put("TC70AF", 48);
        typeMap.put("NTC10UA", 31);
        typeMap.put("ACR", 32);
    }
}

