/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.cryocon;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;
import org.lsst.ccs.utilities.logging.Logger;

public class M24C {
    Logger log = Logger.getLogger((String)"lsst.drivers.cryocon");
    private static final int DEFAULT_TYPE = 0;
    private static final int DEFAULT_PORT = 5000;
    private static final String BNL_DEFAULT_IP = "192.168.2.198";
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private Scpi scpi = new Scpi();

    static {
        typeMap.put("DIODE", 5);
        typeMap.put("PTC100", 20);
        typeMap.put("PTC1K", 21);
        typeMap.put("NONE", 0);
        typeMap.put("INTERNAL", 59);
    }

    public M24C() throws DriverException {
    }

    public M24C(int type, String ident, int param) throws DriverException {
        this.open(type, ident, param);
    }

    public void open(int type, String ident, int param) throws DriverException {
        this.scpi.open(type, ident, param);
        this.log.debug((Object)"Opened Cryogenic Temperature Controller");
    }

    public void openDefault() throws DriverException {
        this.open(0, BNL_DEFAULT_IP, 5000);
    }

    public void close() throws DriverException {
        this.scpi.close();
    }

    public String[] getIdentification() throws DriverException {
        String[] id = this.scpi.getIdentification();
        return id;
    }

    public double getMaxSetPoint(int loop) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("M24C::getMaxSetPoint loop is invalid " + loop);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":MAXSET?";
        String resp = this.scpi.read(cmd);
        return Double.parseDouble(resp.replaceAll("[a-zA-Z]", ""));
    }

    public void setMaxSetPoint(int loop, double temp) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("M24C::setMaxSetPoint loop is invalid " + loop);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":MAXSET " + Double.toString(temp) + ";:*OPC?";
        String resp = this.scpi.read(cmd);
        int retVal = Integer.parseInt(resp);
        if (retVal != 1) {
            throw new DriverException("M24C::setMaxSetPoint returned error code " + resp);
        }
    }

    public double getSetPoint(int loop) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("M24C::getSetPoint loop is invalid " + loop);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":SETPT?";
        String resp = this.scpi.read(cmd);
        return Double.parseDouble(resp.replaceAll("[a-zA-Z]", ""));
    }

    public void setSetPoint(int loop, double temp) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("M24C::setSetPoint loop is invalid " + loop);
        }
        if (temp > this.getMaxSetPoint(loop)) {
            throw new DriverException("M24C::setSetPoint requested temp is too high check MAXSET " + temp);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":SETPT " + Double.toString(temp) + ";:*OPC?";
        String resp = this.scpi.read(cmd);
        int retVal = Integer.parseInt(resp);
        if (retVal != 1) {
            throw new DriverException("M24C::setSetPoint returned error code " + resp);
        }
    }

    public String getSource(int loop) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("M24C::getSource loop is invalid " + loop);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":SOURCE?";
        String resp = this.scpi.read(cmd);
        if (resp.charAt(0) >= 'A' && resp.charAt(0) <= 'D') {
            return resp;
        }
        throw new DriverException("M24C::getSource invalid response " + resp);
    }

    public void setSource(int loop, char channel) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("M24C::setSource loop is invalid " + loop);
        }
        if (channel >= 'A' && channel <= 'D') {
            String cmd = "LOOP " + Integer.toString(loop) + ":SOURCE " + channel + ";:*OPC?";
            String resp = this.scpi.read(cmd);
            int retVal = Integer.parseInt(resp);
            if (retVal != 1) {
                throw new DriverException("M24C::setSource returned error code " + resp);
            }
            return;
        }
        throw new DriverException("M24C::setSource channel is invalid " + channel);
    }

    public void setHeaterRange(int loop, String range) throws DriverException {
        if (loop < 1 || loop > 4) {
            throw new DriverException("M24C::setHeaterRange loop is invalid " + loop);
        }
        String urange = range.toUpperCase();
        if (!(urange.contains("HI") || urange.contains("MID") || urange.contains("LOW"))) {
            throw new DriverException("M24C::setHeaterRange invalid range specified. Allowed values are Hi, MID, LOW. Requested value =  " + urange);
        }
        String cmd = "LOOP " + Integer.toString(loop) + ":RANGE " + urange + ";:*OPC?";
        String resp = this.scpi.read(cmd);
        int retVal = Integer.parseInt(resp);
        if (retVal != 1) {
            throw new DriverException("M24C::setSetHeaterRange returned error code " + resp);
        }
    }

    public double getTemp(char channel) throws DriverException {
        double temp = -999.0;
        if (channel >= 'A' && channel <= 'D') {
            String cmd = "INPUT " + channel + ":TEMP?";
            String resp = this.scpi.read(cmd);
            if (resp.indexOf("...") >= 0 || resp.indexOf("----") >= 0) {
                this.log.debug((Object)("CryoCon channel " + channel + " appears not to be connected."));
            } else {
                temp = Double.parseDouble(resp.replaceAll("[a-zA-Z]", ""));
            }
        } else {
            throw new DriverException("Invalid channel request " + channel);
        }
        return temp;
    }

    public char getUnit(char channel) throws DriverException {
        char upperCh = Character.toUpperCase(channel);
        if (upperCh >= 'A' && upperCh <= 'D') {
            String cmd = "INPUT " + upperCh + ":UNIT?";
            String resp = this.scpi.read(cmd);
            if (!resp.matches("[K|C|F|S]")) {
                throw new DriverException("Invalid response for UNIT?" + resp);
            }
            return resp.charAt(0);
        }
        throw new DriverException("Invalid channel request " + channel);
    }

    public void setUnit(char channel, char unit) throws DriverException {
        Character upperCh = Character.valueOf(Character.toUpperCase(channel));
        Character upperUn = Character.valueOf(Character.toUpperCase(unit));
        if (upperCh.charValue() >= 'A' && upperCh.charValue() <= 'D') {
            if (!upperUn.toString().matches("[K|C|F|S]")) {
                throw new DriverException("Invalid Unit request " + unit);
            }
            String cmd = "INPUT " + upperCh.charValue() + ":UNITS " + upperUn.charValue() + ";:*OPC?";
            String resp = this.scpi.read(cmd);
            int retVal = Integer.parseInt(resp);
            if (retVal != 1) {
                throw new DriverException("Invalid response for UNIT?" + resp);
            }
            return;
        }
        throw new DriverException("Invalid channel request " + channel);
    }

    public void setType(char channel, String typ) throws DriverException {
        Character upperCh = Character.valueOf(Character.toUpperCase(channel));
        if (upperCh.charValue() >= 'A' && upperCh.charValue() <= 'D') {
            Integer ityp = typeMap.get(typ.toUpperCase());
            if (ityp == null) {
                throw new DriverException("Invalid Type request " + typ);
            }
            String cmd = "INPUT " + upperCh.charValue() + ":SENSOR " + ityp + ";:*OPC?";
            String resp = this.scpi.read(cmd);
            int retVal = Integer.parseInt(resp);
            if (retVal != 1) {
                throw new DriverException("Invalid response for TYPE?" + resp);
            }
            return;
        }
        throw new DriverException("Invalid channel request " + channel);
    }

    public void setToControl() throws DriverException {
        String cmd = "CONTROL:*OPC?";
        String resp = this.scpi.read(cmd);
        int retVal = Integer.parseInt(resp);
        if (retVal != 1) {
            throw new DriverException("Invalid response for TYPE?" + resp);
        }
    }

    public boolean isInControl() throws DriverException {
        String cmd = "CONTROL?";
        String resp = this.scpi.read(cmd);
        boolean inControl = false;
        if (resp.contains("ON")) {
            inControl = true;
        }
        return inControl;
    }
}

