/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.cryocon;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.cryocon.M24C;

public class TestM24C {
    private M24C tempDev;

    @Command(name="open", description="Open connection to Model 24C")
    public void open(@Argument(name="type", description="Communications type") int type, @Argument(name="identity", description="Device identifier") String ident, @Argument(name="parameter", description="Device parameter") int param) throws DriverException {
        this.tempDev = new M24C(type, ident, param);
    }

    @Command(name="openDefault", description="Open connection to Default Model 24C")
    public void openDefault() throws DriverException {
        this.tempDev = new M24C();
        this.tempDev.openDefault();
    }

    @Command(name="close", description="Close connection to temp control 24C")
    public void close() throws DriverException {
        this.tempDev.close();
    }

    @Command(name="showident", description="Show Temp Control 24C identification")
    public String showIdentification() throws DriverException {
        String[] ident = this.tempDev.getIdentification();
        return "Manufacturer:    " + ident[0] + "\n" + "Model name:      " + ident[1] + "\n" + "DCI F/W version: " + ident[2] + "\n" + "AI F/W version:  " + ident[3];
    }

    @Command(name="getMaxSetPoint", description="Retrieve MaxSetPoint for loop")
    public double getMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.tempDev.getMaxSetPoint(loop);
    }

    @Command(name="setMaxSetPoint", description="setMaxSetPoint for loop")
    public void setMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        this.tempDev.setMaxSetPoint(loop, temp);
    }

    @Command(name="getSetPoint", description="Retrieve setPoint for loop")
    public double getSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.tempDev.getSetPoint(loop);
    }

    @Command(name="setSetPoint", description="setSetPoint for loop")
    public void setSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        this.tempDev.setSetPoint(loop, temp);
    }

    @Command(name="getLoopSource", description="Retrieve source channel for loop")
    public char getLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.tempDev.getSource(loop).charAt(0);
    }

    @Command(name="setLoopSource", description="Set source channel for loop")
    public void setLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="channel", description="channel [A-D]") String channel) throws DriverException {
        this.tempDev.setSource(loop, channel.charAt(0));
    }

    @Command(name="getTemp", description="Retrieve temperature info")
    public double getTemp(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        char ch = channel.charAt(0);
        return this.tempDev.getTemp(ch);
    }

    @Command(name="getUnit", description="Retrieve temperature units")
    public char getUnit(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        char ch = channel.charAt(0);
        return this.tempDev.getUnit(ch);
    }

    @Command(name="setUnit", description="Set temperature units")
    public void setUnit(@Argument(name="channel", description="Temp Channel to set") String channel, @Argument(name="units", description="Units in [K|C|F|S]") String unit) throws DriverException {
        char ch = channel.charAt(0);
        char un = unit.charAt(0);
        this.tempDev.setUnit(ch, un);
    }
}

