/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.chiller;

import java.time.Duration;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class Chiller
extends Ascii {
    private static final int DEFAULT_PORT = 9760;
    private static final int TIMEOUT = 200;
    private static final int TIMEOUT_SET = 1000;
    private static final double SETPOINT_TOLERANCE = 0.1;
    private static final double SETFLOW_TOLERANCE = 0.1;
    private static final int MAX_SETUP_PARAM = 77;
    private static final String Lbl = "Chiller ";
    private final Duration intervalCheckSet = Duration.ofMillis(10L);
    private int telnetPort = 9760;
    private int timeout = 200;
    private boolean debug = false;
    private boolean first = true;
    private Query[] qval = Query.values();

    public void open(String host, int port) throws DriverException {
        super.open(DriverConstants.ConnType.NET, host, port);
        this.setTimeout(this.timeout);
        this.setTerminator(Ascii.Terminator.CRLF);
        try {
            this.write("SI");
            this.write("DP2");
            this.write("DS");
            this.setParameter(1, "2");
            this.setParameter(16, "0");
            this.setParameter(39, "0");
            this.setParameter(47, "0");
            this.setParameter(35, "5");
            this.first = false;
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(String host) throws DriverException {
        this.open(host, 9760);
    }

    public void setDebug(boolean on_off) {
        this.debug = on_off;
    }

    public String listQueries() {
        String table = "List of all queries for Chiller \n";
        for (int i = 0; i < this.qval.length; ++i) {
            table = table + String.format("\n   %-15s  (%-5s)     %s", new Object[]{this.qval[i], this.qval[i].getCommand(), this.qval[i].getDescription()});
        }
        table = table + "\n";
        return table;
    }

    public String listStatusBits() {
        StatusRegister[] stat = StatusRegister.values();
        String table = "List of status bits \n";
        for (int i = 0; i < stat.length; ++i) {
            table = table + String.format("\n   %-10s   %s", new Object[]{stat[i], stat[i].getDescr()});
        }
        return table;
    }

    public synchronized String queryChiller(Query query) throws DriverException {
        String reply = this.read(query.getCommand());
        int expect = query.getExpectedLines();
        if (expect > 1) {
            for (int nlines = 1; nlines < expect; ++nlines) {
                reply = reply + "\n" + this.read();
            }
        }
        return reply;
    }

    public double getTemperature(Query query) throws DriverException {
        if (!query.getIsTemp()) {
            throw new IllegalArgumentException("Quantity is not a temperature");
        }
        String response = this.queryChiller(query);
        String substr = response.substring(response.lastIndexOf(32) + 1);
        double value = Double.parseDouble(substr);
        return value;
    }

    public double getFlow(Query query) throws DriverException {
        if (query != Query.FLOW_RATE && query != Query.FLOW_SETPT) {
            throw new IllegalArgumentException("Arg must be a flow quantity");
        }
        String response = this.queryChiller(query);
        String substr = response.substring(response.lastIndexOf(32) + 1);
        double value = Double.parseDouble(substr);
        return value;
    }

    public double getPressure(Query query) throws DriverException {
        if (query != Query.PRESSURE_IN && query != Query.PRESSURE_OUT && query != Query.PRESSURE_TANK && query != Query.TANK_P_SET) {
            throw new IllegalArgumentException("Arg must be pressure quantity");
        }
        String response = this.queryChiller(query);
        String substr = response.substring(response.lastIndexOf(32) + 1);
        double value = Double.parseDouble(substr);
        return value;
    }

    public double[] getHeatCool() throws DriverException {
        String[] resp = this.queryChiller(Query.HEAT_COOL).split("%");
        double[] percentages = new double[2];
        for (int i = 0; i < 2; ++i) {
            String substr = resp[i].substring(resp[i].lastIndexOf("=") + 1);
            percentages[i] = Double.parseDouble(substr);
        }
        return percentages;
    }

    public int getLifetime(Life life) throws DriverException {
        String[] lifetime = this.queryChiller(Query.LIFETIME).split("\n");
        String line = lifetime[life.ordinal()];
        String substr = line.substring(line.lastIndexOf(32) + 1);
        int value = Integer.parseInt(substr);
        return value;
    }

    public String decodeEvtReg() throws DriverException {
        String resp = this.queryEvtReg();
        String substr = resp.substring(resp.length() - 2, resp.length());
        int register = Integer.parseUnsignedInt(substr, 16);
        return resp + "  " + EventRegister.decode(register);
    }

    public int getStatusReg() throws DriverException {
        String resp = this.queryChiller(Query.STATE_BITS);
        String substr = resp.substring(resp.length() - 2, resp.length());
        return Integer.parseUnsignedInt(substr, 16);
    }

    public String decodeStatusReg() throws DriverException {
        return StatusRegister.decode(this.getStatusReg());
    }

    public ErrorWords getErrorWords() throws DriverException {
        String errors = this.queryChiller(Query.ERROR_BITS);
        int idx1 = errors.indexOf(32);
        int idx2 = errors.indexOf(32, idx1 + 1);
        int idx3 = errors.indexOf(32, idx2 + 1);
        int idx4 = errors.indexOf(32, idx3 + 1);
        int err1 = Integer.parseInt(errors.substring(idx1 + 1, idx2));
        int err2 = Integer.parseInt(errors.substring(idx2 + 1, idx3));
        int warn1 = Integer.parseInt(errors.substring(idx3 + 1, idx4));
        int warn2 = Integer.parseInt(errors.substring(idx4 + 1));
        return new ErrorWords(err1, err2, warn1, warn2);
    }

    private synchronized String queryEvtReg() throws DriverException {
        String reply = this.read("REA");
        return reply;
    }

    public synchronized String readParameter(int index) throws DriverException {
        if (index >= 0 && index <= 77) {
            String command = "QFA " + index;
            String reply = this.read(command);
            String[] lines = reply.split("/n");
            if (lines.length != 1) {
                throw new DriverException("Expected 1 line in reply, received " + lines.length);
            }
            return reply;
        }
        throw new IllegalArgumentException("Index must be in range 0 to 77");
    }

    void setParameter(int index, String value) throws DriverException {
        if (index >= 0 && index <= 77) {
            String command = "SPA " + index + " " + value;
            this.write(command);
            return;
        }
        throw new IllegalArgumentException("Index must be in range 0 to 77");
    }

    String setAndReadParameter(int index, String value) throws DriverException {
        this.setParameter(index, value);
        return this.readParameter(index);
    }

    public void setParamCommand(SetParam setParam, double ... values) throws DriverException {
        if (values.length != setParam.getNparam()) {
            throw new IllegalArgumentException((Object)((Object)setParam) + " requires " + Integer.toString(setParam.getNparam()) + " parameter(s)");
        }
        for (int i = 0; i < values.length; ++i) {
            FParam fParam = setParam.getParams()[i];
            if (!(values[i] < fParam.getMin()) && !(values[i] > fParam.getMax())) continue;
            throw new IllegalArgumentException(String.format("Parameter %d must be between %f and %f", i, fParam.getMin(), fParam.getMax()));
        }
        String command = setParam.getCommand();
        for (int i = 0; i < values.length; ++i) {
            command = command + " " + Double.toString(values[i]);
        }
        this.write(command);
        long start = System.currentTimeMillis();
        long dt = 0L;
        int istart = 0;
        while (dt < 1000L) {
            if (this.debug) {
                System.out.println("In wait loop, dt = " + dt);
            }
            try {
                Thread.sleep(this.intervalCheckSet.toMillis());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unexpected interrupt while waiting in Chiller.setParamCommand", ex);
            }
            for (int i = istart; i < values.length; ++i) {
                String str = this.readParameter(setParam.getParams()[i].getNumber());
                String substr = str.substring(str.lastIndexOf(32) + 1);
                double val = Double.parseDouble(substr);
                if (this.debug) {
                    System.out.println("param " + i + "  val read = " + val + "  set value = " + values[i]);
                }
                if (Math.abs(val - values[i]) >= setParam.getParams()[i].getTolerance()) break;
                if (i == values.length - 1) {
                    return;
                }
                ++istart;
            }
            dt = System.currentTimeMillis() - start;
            if (!this.debug) continue;
            System.out.println("End of loop, dt = " + dt);
        }
        throw new DriverTimeoutException("timeout while waiting for parameter settings");
    }

    public void setTemperature(double value) throws DriverException {
        String cmndString = "GT " + Double.toString(value);
        this.write(cmndString);
        this.checkSetPoint(value);
    }

    public void setTemperatureWithRamp(double value, double ramp) throws DriverException {
        String cmndString = "RR " + Double.toString(value) + " " + Double.toString(ramp);
        this.write(cmndString);
        this.checkSetPoint(value);
    }

    private void checkSetPoint(double value) throws DriverException {
        long start = System.currentTimeMillis();
        long dt = 0L;
        while (dt < 1000L) {
            try {
                Thread.sleep(this.intervalCheckSet.toMillis());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unexpected interrupt while waiting in Chiller.setParamCommand", ex);
            }
            double setpt = this.getTemperature(Query.SET_POINT);
            if (Math.abs(setpt - value) < 0.1) {
                return;
            }
            dt = System.currentTimeMillis() - start;
        }
        throw new DriverTimeoutException("timeout while waiting for temperature setpoimt");
    }

    public void quitControl() throws DriverException {
        this.write("QU");
    }

    public void setFlow(double value) throws DriverException {
        String cmndString = "PSP " + Double.toString(value);
        this.write(cmndString);
        long start = System.currentTimeMillis();
        long dt = 0L;
        while (dt < 1000L) {
            try {
                Thread.sleep(this.intervalCheckSet.toMillis());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unexpected interrupt while waiting in Chiller.setParamCommand", ex);
            }
            double setpt = this.getFlow(Query.FLOW_SETPT);
            if (Math.abs(setpt - value) < 0.1) {
                return;
            }
            dt = System.currentTimeMillis() - start;
        }
        throw new DriverTimeoutException("timeout while waiting for flow setpoimt");
    }

    public void writeDUT(double temperature) throws DriverException {
        String cmnd = "SDT " + Double.toString(temperature);
    }

    public void clearErrors() throws DriverException {
        this.write("CLE");
    }

    public void clearGuiErrorScreen() throws DriverException {
        this.write("CES");
    }

    public void lockGui(boolean lock) throws DriverException {
        String cmnd = lock ? "FLO" : "FLF";
        this.write(cmnd);
    }

    public void saveParams() throws DriverException {
        this.write("UP");
    }

    public void loadParams() throws DriverException {
        this.write("RUP");
    }

    public void sendDirectCommand(String command, String ... args) throws DriverException {
        if (this.debug) {
            boolean notQuery = true;
            for (int i = 0; i < this.qval.length; ++i) {
                String test = this.qval[i].getCommand();
                int idx = test.indexOf(32);
                if (idx > 0) {
                    test = test.substring(0, idx);
                }
                if (!command.equals(test)) continue;
                notQuery = false;
                break;
            }
            if (command.equals("QFA") || command.equals("TE")) {
                notQuery = false;
            }
            if (!notQuery) {
                throw new DriverException("not allowed for query commands");
            }
        } else {
            throw new DriverException("allowed only in Debug mode");
        }
        this.write(Chiller.makeCommandString(command, args));
    }

    protected static String makeCommandString(String command, String ... args) {
        StringBuilder cmnd = new StringBuilder(command);
        for (String arg : args) {
            cmnd.append(' ').append(arg);
        }
        return cmnd.toString();
    }

    public static class ErrorWords {
        private int err1;
        private int err2;
        private int warn1;
        private int warn2;

        public ErrorWords(int err1, int err2, int warn1, int warn2) {
            this.err1 = err1;
            this.err2 = err2;
            this.warn1 = warn1;
            this.warn2 = warn2;
        }

        public int getError1() {
            return this.err1;
        }

        public int getError2() {
            return this.err2;
        }

        public int getWarning1() {
            return this.warn1;
        }

        public int getWarning2() {
            return this.warn2;
        }

        public String toString() {
            String err = "Error1 = " + Integer.toHexString(this.err1) + "x Error2 = " + Integer.toHexString(this.err2) + "x Warning1 = " + Integer.toHexString(this.warn1) + "x Warning2 = " + Integer.toHexString(this.warn2) + "x ";
            return err;
        }

        public boolean equals(Object y) {
            ErrorWords x = (ErrorWords)y;
            boolean eq = this.err1 == x.getError1() && this.err2 == x.getError2() && this.warn1 == x.getWarning1() && this.warn2 == x.getWarning2();
            return eq;
        }
    }

    public static enum SetParam {
        COLD_PERIOD("CV", 1, new FParam[]{FParam.F02}),
        DUT_INT_COEFF("WDI", 1, new FParam[]{FParam.F60}),
        DUT_PROP_COEFF("WDP", 1, new FParam[]{FParam.F59}),
        DUT_T_LIMITS("SL", 2, new FParam[]{FParam.F27, FParam.F28}),
        DUT_VS_RTD("SD", 2, new FParam[]{FParam.F29, FParam.F30}),
        PID_PARAMS("WP", 4, new FParam[]{FParam.F00, FParam.F10, FParam.F11, FParam.F12}),
        RAMP_RATE("SR", 1, new FParam[]{FParam.F37}),
        SETTLING_BAND("SB", 2, new FParam[]{FParam.F31, FParam.F32}),
        TANK_SETPOINT("SPA 73", 1, new FParam[]{FParam.F73}),
        TEMP_CTRL_MODE("TCM", 1, new FParam[]{FParam.F40}),
        THERMAL_MASS("TM", 1, new FParam[]{FParam.F34});

        private String command;
        private int nparam;
        private FParam[] params;

        private SetParam(String command, int nparam, FParam[] params) {
            this.command = command;
            this.nparam = nparam;
            this.params = params;
        }

        public String getCommand() {
            return this.command;
        }

        public int getNparam() {
            return this.nparam;
        }

        public FParam[] getParams() {
            return this.params;
        }

        public String getDescription() {
            String descr = String.format("%-16s %d param:", new Object[]{this, this.nparam});
            for (int i = 0; i < this.nparam; ++i) {
                descr = descr + "  " + this.params[i].getDescription();
                if (i == this.nparam - 1) continue;
                descr = descr + ",";
            }
            return descr;
        }
    }

    public static enum FParam {
        F00(0, 1.0, 1.0, 64.0, "PID proportional coeff"),
        F02(2, 1.0, 1.0, 32.0, "Cold valve period (s)"),
        F10(10, 1.0, 0.0, 3200.0, "PID integral coeff"),
        F11(11, 1.0, 0.0, 3200.0, "PID difeential coeff"),
        F12(12, 1.0, -99.0, 99.0, "PID heater factor"),
        F27(27, 0.1, -70.0, 30.0, "DUT lower temp limit"),
        F28(28, 0.1, -70.0, 30.0, "DUT upper temp limit"),
        F29(29, 0.1, 1.0, 300.0, "DUT lower DeltaT limit"),
        F30(30, 0.1, 1.0, 300.0, "DUT upper DeltaT limit"),
        F31(31, 0.1, 0.1, 10.0, "SetPoint tolerance (deg-C)"),
        F32(32, 1.0, 0.0, 59.0, "Min SetPoint stable time (s)"),
        F34(34, 1.0, 1.0, 1000.0, "Thermal mass (damping)"),
        F37(37, 0.1, 0.0, 500.0, "Default ramp rate (deg/min)"),
        F40(40, 1.0, 0.0, 1.0, "T-control Normal (0) or DUT (1)"),
        F59(50, 0.1, 0.1, 64.0, "DUT proportional coeff"),
        F60(60, 0.1, 0.0, 64.0, "DUT integral coeff"),
        F73(73, 1.0, 1.0, 50.0, "Tank pressure setpoint");

        private int number;
        private double tol;
        private double min;
        private double max;
        private String descr;

        private FParam(int number, double tol, double min, double max, String descr) {
            this.number = number;
            this.tol = tol;
            this.min = min;
            this.max = max;
            this.descr = descr;
        }

        public int getNumber() {
            return this.number;
        }

        public double getTolerance() {
            return this.tol;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public String getDescription() {
            return this.descr;
        }
    }

    public static enum Life {
        CONTROL("Controller Hours"),
        COMPRESS("Compressor One Hours"),
        PUMP("Pump Hours"),
        VALVE("Valve Activation Count");

        private String descr;

        private Life(String descr) {
            this.descr = descr;
        }

        public String getDescription() {
            return this.descr;
        }
    }

    public static enum StatusRegister {
        ERROR(1, "Error(s) present "),
        WARNING(2, "Warning(s) present "),
        PGM_FULL(4, "Program Buffer over 0.75 full "),
        T_CONTROL(8, "RunState: Controlling T "),
        AT_SETPT(16, "At Temperature SetPoint "),
        SRQ_SET(32, "SRQ Set "),
        CMPRS_ON(64, "Compressors on "),
        UNUSED_7(128, "Unused Bit7 ");

        private int mask;
        private String descr;

        private StatusRegister(int mask, String descr) {
            this.mask = mask;
            this.descr = descr;
        }

        public int getMask() {
            return this.mask;
        }

        public String getDescr() {
            return this.descr;
        }

        public static String decode(int register) {
            String decoded = "StatusRegister = " + Integer.toHexString(register) + "x:";
            StatusRegister[] stat = StatusRegister.values();
            int nbits = stat.length;
            for (int i = 0; i < nbits; ++i) {
                String st = (register & stat[i].mask) != 0 ? "Yes" : "No ";
                decoded = decoded + "   " + (Object)((Object)stat[i]) + " " + st;
            }
            return decoded;
        }
    }

    public static enum EventRegister {
        BAD_ARG(1, "Bad_Argument "),
        PGM_FULL(2, "PgmBuffer_0.75Full "),
        BAD_CMND(4, "UnrecognizedCmnd "),
        DWELLTIME(8, "DwellTime_Done "),
        SETPOINT(16, "SetPoint_Reached "),
        CMND_OVFL(32, "CmndBufferOverrun  "),
        UNUSED_6(64, "Unused_Bit6 "),
        UNUSED_7(128, "Unused_Bit7 ");

        private int mask;
        private String descr;

        private EventRegister(int mask, String descr) {
            this.mask = mask;
            this.descr = descr;
        }

        public static String decode(int register) {
            String decoded = "EventRegister:  ";
            EventRegister[] bits = EventRegister.values();
            int nbits = bits.length;
            for (int i = 0; i < nbits; ++i) {
                if ((register & bits[i].mask) == 0) continue;
                decoded = decoded + bits[i].toString() + " ";
            }
            return decoded;
        }
    }

    public static enum Query {
        IDENTITY("*IDN?", "Controller Identity", 1, false),
        LOOP_COUNT("LCT", "Loop Count (Program Mode)", 1, false),
        LAT_CMND("QC", "Last Command String", 1, false),
        ERR_BITS_OLD("QCE", "Error1, Error2, Warning1", 1, false),
        DIAG_INFO("QDI", "Diagnostics Info", 2, false),
        ERROR_BITS("QEW", "Error1, Error2, Warn1, Warn2", 1, false),
        TANK_P_SET("QFA 73", "Tank pressure setpoint", 1, false),
        LIFETIME("QLP", "Life Time Parameters", 4, false),
        REMOTE_MODE("QM", "1 = Immediate, 2 = Program", 1, false),
        SERIAL_NO("QN", "Controller Serial Number", 1, false),
        PGM_STATE("QPG", "Remote Program Running State", 1, false),
        HEAT_COOL("QPL", "Heat and Cool Percents of Max", 1, false),
        TEMP_RANGE("QR", "Controller Temperature Range", 1, false),
        SET_POINT("QS", "Probe Number and Set Point", 1, true),
        DYNAMIC_SET("QSC", "Probe No. and Control Set Point", 1, true),
        SYS_INFO("QSI", "System Information", 7, false),
        FIRMWARE("QV", "Firmware Version", 1, false),
        WARN2("QWT", "Warning2 (bits)", 1, false),
        FLOW_RATE("RCF", "Flow Rate (GPM or LPM)", 1, false),
        STATUS("RCS", "Chiller Status (hex)", 1, false),
        INPUT_BITS1("RID 1", "5V Digital Inputs (binary)", 1, false),
        INPUT_BITS2("RID 2", "24V Digital Inputs (binary)", 1, false),
        PRESSURE_IN("RIP", "Input Pressure", 1, false),
        OUTPUT_BITS1("ROD 1", "5V Digital Outputs (binary)", 1, false),
        OUTPUT_BITS2("ROD 2", "24V Digital Outputs (binary)", 1, false),
        PRESSURE_OUT("ROP", "Output Pressure", 1, false),
        PID_PARAM("RP", "PID Constants (F0, F10 to F12)", 1, false),
        FLOW_SETPT("RPS", "Pressure or Flow Setpoint", 1, false),
        STATE_BITS("RSA", "Chiller State Bits (hex)", 1, false),
        GPIB_TIMEOUT("RTM", "GPIB timeout (F44)", 1, false),
        PRESSURE_TANK("RTP", "Tank Pressure", 1, false),
        TEMPERATURE("TP 1", "Coolant Output Temperature", 1, true),
        T_CONDENSER("TP 5", "Temperature CondensorOut", 1, true),
        T_TXV_BULB("TP 6", "Temperture TXV_Bulb", 1, true),
        T_STAGE2EVAP("TP 7", "Temperature Stage2Evap", 1, true);

        private String command;
        private String description;
        private int expectedLines;
        private boolean isTemp;

        private Query(String command, String description, int expectedLines, boolean isTemp) {
            this.command = command;
            this.description = description;
            this.expectedLines = expectedLines;
            this.isTemp = isTemp;
        }

        public String getCommand() {
            return this.command;
        }

        public String getDescription() {
            return this.description;
        }

        public int getExpectedLines() {
            return this.expectedLines;
        }

        public boolean getIsTemp() {
            return this.isTemp;
        }
    }
}

