/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.chiller;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.chiller.Chiller;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestChiller {
    private final Chiller chiller = new Chiller();

    @Command(name="open", description="Open connection to chiller")
    public void open(@Argument(description="Host name") String host, @Argument(description="Port number", defaultValue="9760") int port) throws DriverException {
        this.chiller.open(host, port);
    }

    @Command(name="close", description="Close connection to chiller")
    public void close() throws DriverException {
        this.chiller.close();
    }

    @Command(name="setDebug", description="set debug mode true/false")
    public void setDebug(@Argument(description="true/false") boolean debug) {
        this.chiller.setDebug(debug);
    }

    @Command(name="listQueries", description="List available queries")
    public String listQueries() {
        return this.chiller.listQueries();
    }

    @Command(name="listSetParams", description="List implemented parameter-setting commands")
    public String listSetParams() {
        Chiller.SetParam[] val = Chiller.SetParam.values();
        String table = "Implemented parameter-setting commands:";
        for (int i = 0; i < val.length; ++i) {
            table = table + "\n  " + val[i].getDescription();
        }
        return table;
    }

    @Command(name="listStatusBits", description="List status register bits")
    public String listStatusBits() {
        return this.chiller.listStatusBits();
    }

    @Command(name="queryChiller", description="send specified query to chiller")
    public String queryChiller(@Argument(description="Read Enumerated quantity from Chiller") Chiller.Query quantity) throws DriverException {
        String response = this.chiller.queryChiller(quantity);
        return response;
    }

    @Command(name="readParameter", description="Read value of specified parameter")
    public String readParameter(@Argument(description="index of parameter") int index) throws DriverException {
        return this.chiller.readParameter(index);
    }

    @Command(name="setAnyParameter", description="Set value of specified parameter")
    public void setAnyParameter(@Argument(description="index of parameter") int index, @Argument(description="value to be set") String value) throws DriverException {
        this.chiller.setParameter(index, value);
    }

    @Command(name="setAndReadAnyParameter", description="Set value of specified paramete and read it backr")
    public String setAndReadAnyParameter(@Argument(description="index of parameter") int index, @Argument(description="value to set") String value) throws DriverException {
        return this.chiller.setAndReadParameter(index, value);
    }

    @Command(name="setParams", description="Invoke Chiller command tp set parameter(s)")
    public void setParams(@Argument(description="enumerated command") Chiller.SetParam setParam, double ... values) throws DriverException {
        this.chiller.setParamCommand(setParam, values);
    }

    @Command(name="showTemperature", description="numerical value of a temperature reading or set-point")
    public String showTemperature(@Argument(description="which quantity") Chiller.Query quantity) throws DriverException {
        String temp = "Example of getTemperature " + quantity.toString() + ":  " + this.chiller.getTemperature(quantity);
        return temp;
    }

    @Command(name="showFlow", description="numerical value of a flow reading or set-point")
    public String showFlow(@Argument(description="which quantity") Chiller.Query quantity) throws DriverException {
        String flow = "Example of getFlow " + quantity.toString() + ":  " + this.chiller.getFlow(quantity);
        return flow;
    }

    @Command(name="showPressure", description="numerical value of a pressure reading")
    public String showPressure(@Argument(description="which quantity") Chiller.Query quantity) throws DriverException {
        String pressure = "Example of getPresssure " + quantity.toString() + ":  " + this.chiller.getPressure(quantity);
        return pressure;
    }

    @Command(name="showLifetime", description="numerical value of lifetime")
    public String showLifetime(@Argument(description="which quantity") Chiller.Life quantity) throws DriverException {
        String lifetime = "Example of getLifetime " + quantity.getDescription() + ":  " + this.chiller.getLifetime(quantity);
        return lifetime;
    }

    @Command(name="showHeatCool", description="numerical values of heat/cool percentages")
    public String showHeatCool() throws DriverException {
        double[] percentages = this.chiller.getHeatCool();
        String heatcool = "Heat, Cool percentages = " + percentages[0] + ", " + percentages[1];
        return heatcool;
    }

    @Command(name="showEvtReg", description="Show decoded Event Register")
    public String showEvtReg() throws DriverException {
        return this.chiller.decodeEvtReg();
    }

    @Command(name="showStatusReg", description="Show decoded Status Register")
    public String showStatusReg() throws DriverException {
        return this.chiller.decodeStatusReg();
    }

    @Command(name="showErrorWords", description="Show error and warning words in hex")
    public String showErrorWords() throws DriverException {
        return this.chiller.getErrorWords().toString();
    }

    @Command(name="sendDebugCommand", description="Send non-query command to chiller, debug-mode")
    public void sendDebugCommand(@Argument(description="command String") String command, String ... args) throws DriverException {
        this.chiller.sendDirectCommand(command, args);
    }
}

