/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.chiller;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class Chiller
extends Ascii {
    private static final int DEFAULT_PORT = 9760;
    private static final int TIMEOUT = 100;
    private static final int MAX_SETUP_PARAM = 71;
    private static final String Lbl = "Chiller ";
    private int telnetPort = 9760;
    private int timeout = 100;
    private boolean debug = false;
    private Query[] qval = Query.values();
    private int error1Word;
    private int error2Word;
    private int warningWord;

    public void open(String host, int port) throws DriverException {
        super.open(DriverConstants.ConnType.NET, host, port);
        this.setTimeout(this.timeout);
        this.setTerminator(Ascii.Terminator.CRLF);
        try {
            this.write("DC");
            this.write("SI");
            this.write("DP2");
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(String host) throws DriverException {
        this.open(host, 9760);
    }

    public void setDebug(boolean on_off) {
        this.debug = on_off;
    }

    public String listQueries() {
        String table = "List of all queries for Chiller \n";
        for (int i = 0; i < this.qval.length; ++i) {
            table = table + String.format("\n   %-15s  (%-5s)     %s", new Object[]{this.qval[i], this.qval[i].getCommand(), this.qval[i].getDescription()});
        }
        table = table + "\n";
        return table;
    }

    public String queryChiller(Query query) throws DriverException {
        String reply = this.read(query.getCommand());
        int expect = query.getExpectedLines();
        if (expect > 1) {
            for (int nlines = 1; nlines < expect; ++nlines) {
                reply = reply + "\n" + this.read();
            }
        }
        return reply;
    }

    public String readParameter(int index) throws DriverException {
        if (index >= 0 && index <= 71) {
            String command = "QFA " + index;
            String reply = this.read(command);
            String[] lines = reply.split("/n");
            if (lines.length != 1) {
                throw new DriverException("Expected 1 line in reply, received " + lines.length);
            }
            return reply;
        }
        throw new IllegalArgumentException("Index must be in range 0 to 71");
    }

    public void setParameter(int index, String value) throws DriverException {
        if (index >= 0 && index <= 71) {
            String command = "SPA " + index + " " + value;
            this.write(command);
            return;
        }
        throw new IllegalArgumentException("Index must be in range 0 to 71");
    }

    public String setAndReadParameter(int index, String value) throws DriverException {
        this.setParameter(index, value);
        return this.readParameter(index);
    }

    public double getTemperature(Query query) throws DriverException {
        if (!query.getIsTemp()) {
            throw new IllegalArgumentException("Quantity is not a temperature");
        }
        String response = this.queryChiller(query);
        String substr = response.substring(response.lastIndexOf(32) + 1);
        double value = Double.parseDouble(substr);
        return value;
    }

    public int getFlow(Query query) throws DriverException {
        if (query != Query.FLOW_RATE && query != Query.FLOW_SETPT) {
            throw new IllegalArgumentException("Arg must be a flow quantity");
        }
        String response = this.queryChiller(query);
        String substr = response.substring(response.lastIndexOf(32) + 1);
        int value = Integer.parseInt(substr);
        return value;
    }

    public int getLifetime(Life life) throws DriverException {
        String[] lifetime = this.queryChiller(Query.LIFETIME).split("\n");
        String line = lifetime[life.ordinal()];
        String substr = line.substring(line.lastIndexOf(32) + 1);
        int value = Integer.parseInt(substr);
        return value;
    }

    public String decodeEvtReg() throws DriverException {
        String resp = this.queryChiller(Query.EVENT_BITS);
        String substr = resp.substring(resp.length() - 2, resp.length());
        int register = Integer.parseUnsignedInt(substr, 16);
        return resp + "  " + EventRegister.decode(register);
    }

    public String decodeStatusReg() throws DriverException {
        String resp = this.queryChiller(Query.STATE_BITS);
        String substr = resp.substring(resp.length() - 2, resp.length());
        int register = Integer.parseUnsignedInt(substr, 16);
        return resp + "  " + StatusRegister.decode(register);
    }

    private void extractErrorWords() throws DriverException {
        String errors = this.queryChiller(Query.ERROR_BITS);
        int idx1 = errors.indexOf(32);
        int idx2 = errors.indexOf(32, idx1 + 1);
        int idx3 = errors.indexOf(32, idx2 + 1);
        this.error1Word = Integer.parseInt(errors.substring(idx1 + 1, idx2));
        this.error2Word = Integer.parseInt(errors.substring(idx2 + 1, idx3));
        this.warningWord = Integer.parseInt(errors.substring(idx3 + 1));
    }

    public String showErrors() throws DriverException {
        this.extractErrorWords();
        String err = "Error1 (hex) = " + Integer.toHexString(this.error1Word) + ", Error2 (hex) = " + Integer.toHexString(this.error2Word) + ", Warning (hex) = " + Integer.toHexString(this.warningWord);
        return err;
    }

    public void sendDirectCommand(String command, String ... args) throws DriverException {
        if (this.debug) {
            boolean notQuery = true;
            for (int i = 0; i < this.qval.length; ++i) {
                String test = this.qval[i].getCommand();
                int idx = test.indexOf(32);
                if (idx > 0) {
                    test = test.substring(0, idx);
                }
                if (!command.equals(test)) continue;
                notQuery = false;
                break;
            }
            if (command.equals("QFA") || command.equals("TE")) {
                notQuery = false;
            }
            if (!notQuery) {
                throw new DriverException("not allowed for query commands");
            }
        } else {
            throw new DriverException("allowed only in Debug mode");
        }
        this.write(Chiller.makeCommandString(command, args));
    }

    protected static String makeCommandString(String command, String ... args) {
        StringBuilder cmnd = new StringBuilder(command);
        for (String arg : args) {
            cmnd.append(' ').append(arg);
        }
        return cmnd.toString();
    }

    public static enum Life {
        CONTROL("Controller Hours"),
        COMPRESS("Compressor One Hours"),
        PUMP("Pump Hours"),
        VALVE("Valve Activation Count");

        private String descr;

        private Life(String descr) {
            this.descr = descr;
        }

        public String getDescription() {
            return this.descr;
        }
    }

    public static enum StatusRegister {
        ERROR(1, "ErrorPresent "),
        WARNING(2, "WarningPresent "),
        PGM_FULL(4, "PgmBuff_0.75Full "),
        RUN_STATE(8, "RunningState "),
        SETPOINT(16, "At_SetPoint "),
        SRQ_SET(32, "SRQ_Set "),
        UNUSED_6(64, "Unused_Bit6 "),
        UNUSED_7(128, "Unused_Bit7 ");

        private int mask;
        private String descr;

        private StatusRegister(int mask, String descr) {
            this.mask = mask;
            this.descr = descr;
        }

        public static String decode(int register) {
            String decoded = "StatusRegister:  ";
            StatusRegister[] bits = StatusRegister.values();
            int nbits = bits.length;
            for (int i = 0; i < nbits; ++i) {
                if ((register & bits[i].mask) == 0) continue;
                decoded = decoded + bits[i].toString() + " ";
            }
            return decoded;
        }
    }

    public static enum EventRegister {
        BAD_ARG(1, "Bad_Argument "),
        PGM_FULL(2, "PgmBuffer_0.75Full "),
        BAD_CMND(4, "UnrecognizedCmnd "),
        DWELLTIME(8, "DwellTime_Done "),
        SETPOINT(16, "SetPoint_Reached "),
        CMND_OVFL(32, "CmndBufferOverrun  "),
        UNUSED_6(64, "Unused_Bit6 "),
        UNUSED_7(128, "Unused_Bit7 ");

        private int mask;
        private String descr;

        private EventRegister(int mask, String descr) {
            this.mask = mask;
            this.descr = descr;
        }

        public static String decode(int register) {
            String decoded = "EventRegister:  ";
            EventRegister[] bits = EventRegister.values();
            int nbits = bits.length;
            for (int i = 0; i < nbits; ++i) {
                if ((register & bits[i].mask) == 0) continue;
                decoded = decoded + bits[i].toString() + " ";
            }
            return decoded;
        }
    }

    public static enum Query {
        IDENTITY("*IDN?", "Controller Identity", 1, false),
        LOOP_COUNT("LCT", "Loop Count (Program Mode)", 1, false),
        LAT_CMND("QC", "Last Command String", 1, false),
        ERROR_BITS("QCE", "Error1, Error2, Warning (hex)", 1, false),
        DIAG_INFO("QDI", "Diagnostics Info", 2, false),
        LIFETIME("QLP", "Life Time Parameters", 4, false),
        REMOTE_MODE("QM", "1 = Immediate, 2 = Program", 1, false),
        SERIAL_NO("QN", "Controller Serial Number", 1, false),
        PGM_STATE("QPG", "Remote Program Running State", 1, false),
        TEMP_RANGE("QR", "Controller Temperature Range", 1, false),
        SET_POINT("QS", "Probe Number and Set Point", 1, true),
        DYNAMIC_SET("QSC", "Probe No. and Control Set Point", 1, true),
        SYS_INFO("QSI", "System Information", 7, false),
        FIRMWARE("QV", "Firmware Version", 1, false),
        FLOW_RATE("RCF", "Flow Rate (GPM or LPM)", 1, false),
        STATUS("RCS", "Chiller Status (hex)", 1, false),
        EVENT_BITS("REA", "Event Bits (hex)", 1, false),
        INPUT_BITS1("RID 1", "5V Digital Inputs (binary)", 1, false),
        INPUT_BITS2("RID 2", "24V Digital Inputs (binary)", 1, false),
        OUTPUT_BITS1("ROD 1", "5V Digital Outputs (binary)", 1, false),
        OUTPUT_BITS2("ROD 2", "24V Digital Outputs (binary)", 1, false),
        PRESSURE("ROP", "Output Pressure", 1, false),
        FLOW_SETPT("RPS", "Pressure or Flow Setpoint", 1, false),
        STATE_BITS("RSA", "Chiller State Bits (hex)", 1, false),
        GPIB_TIMEOUT("RTM", "GPIB timeout (F44)", 1, false),
        TEMPERATURE("TP 1", "Coolant Output Temperature", 1, true),
        T_CONDENSER("TP 5", "Temperature CondensorOut", 1, true),
        T_TXV_BULB("TP 6", "Temperture TXV_Bulb", 1, true),
        T_STAGE2EVAP("TP 7", "Temperature Stage2Evap", 1, true);

        private String command;
        private String description;
        private int expectedLines;
        private boolean isTemp;

        private Query(String command, String description, int expectedLines, boolean isTemp) {
            this.command = command;
            this.description = description;
            this.expectedLines = expectedLines;
            this.isTemp = isTemp;
        }

        public String getCommand() {
            return this.command;
        }

        public String getDescription() {
            return this.description;
        }

        public int getExpectedLines() {
            return this.expectedLines;
        }

        public boolean getIsTemp() {
            return this.isTemp;
        }
    }
}

