package org.lsst.ccs.drivers.ccob.jni;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.ccob.CCOBInterface;
import org.lsst.ccs.drivers.commons.DriverException;

public class CcobJNI implements CCOBInterface {

    static {
        System.out.println("java.library.path: "+System.getProperty("java.library.path"));
        
        System.out.println("**** Loading libCcobJNI.so");
        try {
            System.loadLibrary("CcobJNI");   // No path, no lib and no .so
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("**** Done Loading the library ");
    }

    @Command(name = "sayHello", description = "Says Hello over JNI Bridge")
    public native String sayHello();

    public static void main(String[] args) {
        CcobJNI app = new CcobJNI();
        System.out.println(app.sayHello());
    }

    @Command(name = "init", description = "init")
    @Override
    public native void init();

    @Command(name = "stop", description = "stop")
    @Override
    public native void stop();

    @Override
    public native String version() throws DriverException;

    @Override
    public native String misc() throws DriverException;

    @Override
    public native String manu() throws DriverException;

    @Override
    public native String date() throws DriverException;

    @Override
    public native String device() throws DriverException;

    @Override
    public native void selectLed(LED led) throws DriverException;

    @Override
    public native void setLedCurrent(double current) throws DriverException;

    @Override
    public native void setExposureTime(double time) throws DriverException;

    @Override
    public native void pulse() throws DriverException;

    @Override
    public native void shutter() throws DriverException;

    @Override
    public native void startExposure() throws DriverException;

    @Override
    public native boolean pollEnd() throws DriverException;

    @Override
    public native CCOBDataRead getAdcValues() throws DriverException;

    @Override
    public native double getAdcPhotoDiode() throws DriverException;

    @Override
    public native void ledOn(int Led, int On) throws DriverException;

    @Override
    public native boolean readButton(int Button) throws DriverException;
}
