/*
 * Decompiled with CFR 0.152.
 */
import org.junit.Test;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.ccob.CCOBInterface;
import org.lsst.ccs.drivers.ccob.CCOBSim;

public class CCOBDriverTest {
    @Test
    public void testCcobDriver() throws Exception {
        CCOBSim app = new CCOBSim();
        System.out.println();
        app.init();
        app.ledOn(1, 1);
        app.ledOn(2, 1);
        app.ledOn(3, 1);
        app.ledOn(4, 1);
        System.out.println("Device: " + app.device());
        System.out.println("Version:" + app.version());
        System.out.println("Date:   " + app.date());
        System.out.println("Misc:   " + app.misc());
        System.out.println("Manu:   " + app.manu());
        app.selectLED(CCOBInterface.LED.BLUE);
        app.setLEDCurrent(0.2);
        app.pulse();
        app.setExposureTime(0.5);
        app.startExposure();
        while (!app.pollEnd()) {
            Thread.sleep(100L);
        }
        CCOBDataRead ADC = app.getAdcValues();
        System.out.println(ADC);
        double PD = app.getAdcPhotoDiode();
        System.out.println("PhotoDiode: " + PD);
        System.out.println("Button 0: " + app.readButton(0));
        System.out.println("Button 1: " + app.readButton(1));
        System.out.println("Button 2: " + app.readButton(2));
        System.out.println("Button 3: " + app.readButton(3));
        System.out.println("Button 4: " + app.readButton(4));
        app.selectLED(CCOBInterface.LED.RED);
        app.shutter();
        app.startExposure();
        while (!app.pollEnd()) {
            Thread.sleep(100L);
        }
        ADC = app.getAdcValues();
        System.out.println(ADC);
        PD = app.getAdcPhotoDiode();
        System.out.println("PhotoDiode: " + PD);
        app.ledOn(1, 0);
        app.ledOn(2, 0);
        app.ledOn(3, 0);
        app.ledOn(4, 0);
        app.stop();
        System.out.println();
    }
}

