package org.lsst.ccs.drivers.ccob;

import java.util.Arrays;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.shell.JLineShell;

/**
 *
 * @author emarin
 */
public class TestCcobSocket {
    
    public static void main(String[] args) throws Exception {
        System.out.println(Arrays.toString(args));
        String host = "127.0.0.1";
        int port = 1557;
        if(args != null && args.length >= 2) {
            host = args[0];
            port = Integer.valueOf(args[1]);
        }
        CCOBCommands ccobCommands = new CCOBCommands(new CCOBSocketDriver(host, port));
         // Building the composite dictionary for this object
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        
        compositeSet.add(builder.buildCommandSet(ccobCommands));
        JLineShell shell = new JLineShell(compositeSet);
        shell.run();
        System.exit(0);    
    }
    
}
