/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ccob;

import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.ccob.CCOBInterface;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.usb.UsbDevice;
import org.lsst.ccs.drivers.usb.UsbLib;
import org.lsst.ccs.utilities.conv.Convert;

public class CCOBUsb
implements CCOBInterface {
    private static final int CCOB_VID = 1240;
    private static final int CCOB_DID = 63;
    private static final int EP_IN = 129;
    private static final int EP_OUT = 1;
    private static final int BUFF_SIZE = 64;
    private static final int READ_TIMEOUT = 1000;
    private static final int DAC_MAX = 65535;
    private static final byte CID_INIT = 0;
    private static final byte CID_STOP = 1;
    private static final byte CID_MISC = 11;
    private static final byte CID_MANU = 12;
    private static final byte CID_DATE = 13;
    private static final byte CID_VERSION = 14;
    private static final byte CID_DEVICE = 15;
    private static final byte CID_SELECT_LED = 16;
    private static final byte CID_SET_LED_CURRENT = 17;
    private static final byte CID_PULSE_LED = 18;
    private static final byte CID_USE_SHUTTER = 19;
    private static final byte CID_SET_EXPOSURE_TIME = 20;
    private static final byte CID_START_EXPOSURE = 21;
    private static final byte CID_POLL_END = 22;
    private static final byte CID_SET_HEATER_CURRENT = 32;
    private static final byte CID_SET_TEMP_SETPOINT = 33;
    private static final byte CID_SET_PID_PARAM = 34;
    private static final byte CID_START_PID = 33;
    private static final byte CID_STOP_PID = 34;
    private static final byte CID_GET_ADC_VALUES = 48;
    private static final byte CID_LED_1_OFF = 49;
    private static final byte CID_LED_1_ON = 50;
    private static final byte CID_LED_2_OFF = 51;
    private static final byte CID_LED_2_ON = 52;
    private static final byte CID_LED_3_OFF = 53;
    private static final byte CID_LED_3_ON = 54;
    private static final byte CID_LED_4_OFF = 55;
    private static final byte CID_LED_4_ON = 56;
    private static final byte CID_GET_ADC_PHOTODIODE = 64;
    private static final byte CID_SW0 = 80;
    private static final byte CID_SW1 = 81;
    private static final byte CID_SW2 = 82;
    private static final byte CID_SW3 = 83;
    private static final byte CID_SW4 = 84;
    private static final byte CID_RESP = -128;
    private static final byte CID_ERROR = -1;
    private static final int ADC_TYPE_VOLTAGE = 0;
    private static final int ADC_TYPE_CURRENT = 1;
    private static final int ADC_TYPE_TEMP = 2;
    private static final double CNV_ADC_VOLTS = 6.250095368886855E-5;
    private static final double CNV_ADC_AMPS = 5.617303730830854E-6;
    private static final double CNV_TEMP_A = 0.0039083;
    private static final double CNV_TEMP_B = -5.775E-7;
    private static final double CNV_DAC_AMPS = 240054.94505494504;
    private static final double CNV_DAC_TIME = 2.1318E-5;
    private static final int[] adcType = new int[8];
    private static final byte[] ledCmnds;
    private static final byte[] switchCmnds;
    private final int index;
    private UsbDevice usb;
    private boolean debug = false;

    CCOBUsb() {
        this(0);
    }

    CCOBUsb(int index) {
        this.index = index;
    }

    @Override
    public void init() throws DriverException {
        if (this.usb != null) {
            this.throwException("Device is already connected");
        }
        this.usb = UsbLib.getDevice((int)1240, (int)63, null, (int)this.index);
        if (this.usb == null) {
            this.throwException("Device not found");
        }
        try {
            this.usb.claimInterface(0, true);
        }
        catch (DriverException e) {
            this.usb.close();
            this.usb = null;
            throw e;
        }
        this.writeCommand((byte)0);
    }

    @Override
    public void stop() throws DriverException {
        this.writeCommand((byte)1);
        this.usb.releaseInterface(0);
        this.usb.close();
        this.usb = null;
    }

    @Override
    public String misc() throws DriverException {
        return this.readString((byte)11);
    }

    @Override
    public String manu() throws DriverException {
        return this.readString((byte)12);
    }

    @Override
    public String date() throws DriverException {
        return this.readString((byte)13);
    }

    @Override
    public String version() throws DriverException {
        return this.readString((byte)14);
    }

    @Override
    public String device() throws DriverException {
        return this.readString((byte)15);
    }

    @Override
    public void selectLed(CCOBInterface.LED led) throws DriverException {
        this.read(new byte[]{2, 16, (byte)led.ordinal()});
    }

    @Override
    public void setLedCurrent(double current) throws DriverException {
        byte[] cmnd = new byte[]{4, 17, 0, 0, 0};
        int dac = (int)(240054.94505494504 * current);
        Convert.shortToBytes((short)((short)Math.max(Math.min(dac, 65535), 0)), (byte[])cmnd, (int)3);
        this.read(cmnd);
    }

    @Override
    public void setExposureTime(double time) throws DriverException {
        byte[] cmnd = new byte[]{3, 20, 0, 0};
        int dac = 65535 - (int)(time / 2.1318E-5);
        Convert.shortToBytes((short)((short)Math.max(Math.min(dac, 65535), 0)), (byte[])cmnd, (int)2);
        this.read(cmnd);
    }

    @Override
    public void pulse() throws DriverException {
        this.writeCommand((byte)18);
    }

    @Override
    public void shutter() throws DriverException {
        this.writeCommand((byte)19);
    }

    @Override
    public void startExposure() throws DriverException {
        this.writeCommand((byte)21);
    }

    @Override
    public boolean pollEnd() throws DriverException {
        byte[] resp = this.read(new byte[]{1, 22});
        if (resp[0] < 2) {
            this.throwException("Response to pollEnd is too short");
        }
        return resp[2] != 0;
    }

    @Override
    public CCOBDataRead getAdcValues() throws DriverException {
        byte[] resp = this.read(new byte[]{1, 48});
        if (resp[0] < 17) {
            this.throwException("Response to getAdcValues is too short");
        }
        double[] data = new double[8];
        block5: for (int j = 0; j < 8; ++j) {
            int raw = Convert.bytesToShortBE((byte[])resp, (int)(2 * j + 2)) & 0xFFFF;
            switch (adcType[j]) {
                case 0: {
                    data[j] = 6.250095368886855E-5 * (double)raw;
                    continue block5;
                }
                case 1: {
                    data[j] = 5.617303730830854E-6 * (double)raw;
                    continue block5;
                }
                case 2: {
                    data[j] = CCOBUsb.convertAdcTemp(raw);
                }
            }
        }
        return new CCOBDataRead(data);
    }

    @Override
    public double getAdcPhotoDiode() throws DriverException {
        byte[] resp = this.read(new byte[]{1, 64});
        if (resp[0] < 3) {
            this.throwException("Response to getAdcPhotoDiode is too short");
        }
        return 6.250095368886855E-5 * (double)(Convert.bytesToShortBE((byte[])resp, (int)2) & 0xFFFF);
    }

    @Override
    public void ledOn(int led, int on) throws DriverException {
        if (led < 1 || led > 4) {
            this.throwException("Invalid board LED number");
        }
        this.writeCommand(ledCmnds[2 * (led - 1) + (on == 0 ? 0 : 1)]);
    }

    @Override
    public boolean readButton(int button) throws DriverException {
        byte[] resp;
        if (button < 0 || button > 4) {
            this.throwException("Invalid button number");
        }
        if ((resp = this.read(new byte[]{1, switchCmnds[button]}))[0] < 2) {
            this.throwException("Response to readButton is too short");
        }
        return resp[2] == 0;
    }

    private static double convertAdcTemp(int adc) {
        return (Math.sqrt(1.527480889E-5 + -2.31E-6 * (6.250095368886855E-5 * (double)adc - 1.0)) - 0.0039083) / -1.155E-6;
    }

    private void writeCommand(byte code) throws DriverException {
        this.read(new byte[]{1, code});
    }

    private String readString(byte code) throws DriverException {
        byte[] resp = this.read(new byte[]{1, code});
        return new String(resp, 2, resp[0] - 2);
    }

    private synchronized byte[] read(byte[] cmnd) throws DriverException {
        if (this.usb == null) {
            this.throwException("Device is not connected");
        }
        this.usb.interruptWrite(1, cmnd, 0, cmnd.length, 0);
        byte[] resp = new byte[64];
        int leng = this.usb.interruptRead(129, resp, 0, resp.length, 1000);
        if (this.debug) {
            System.out.format("Response (%s):", leng);
            for (int j = 0; j < 20; ++j) {
                System.out.format(" %02x", resp[j] & 0xFF);
            }
            System.out.println();
        }
        if (leng < 2 || resp[0] < 1) {
            this.throwException("Response is too short");
        }
        if ((cmnd[1] | 0xFFFFFF80) != resp[1]) {
            this.throwException("Response doesn't match command");
        }
        return resp;
    }

    private void throwException(String msg) throws DriverException {
        throw new DriverException("CCOB error: " + msg);
    }

    static {
        CCOBUsb.adcType[0] = 0;
        CCOBUsb.adcType[1] = 1;
        CCOBUsb.adcType[2] = 0;
        CCOBUsb.adcType[3] = 2;
        CCOBUsb.adcType[4] = 2;
        CCOBUsb.adcType[5] = 1;
        CCOBUsb.adcType[6] = 2;
        CCOBUsb.adcType[7] = 2;
        ledCmnds = new byte[]{49, 50, 51, 52, 53, 54, 55, 56};
        switchCmnds = new byte[]{80, 81, 82, 83, 84};
    }
}

