package org.lsst.ccs.drivers.canopenjni;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * Annotate the methods of CanOpenInterface with @Command annotation.
 * @author emarin
 * @deprecated This class is no longer needed since the methods of CanOpenInterface
 *             have been annotated with the @Command interface.
 */
@Deprecated
public class CanOpenCommands implements CanOpenInterface {
        
    private final CanOpenInterface coi;

    public CanOpenCommands(CanOpenInterface coi) {
        this.coi = coi;
    }

    @Override
    @Command
    public void init(int master, String baud, String busName, int nodeID) throws DriverException {
        coi.init(master, baud, busName, nodeID);
    }

    @Override
    @Command
    public void addReceivedPDO(int cobId) throws DriverException {
        coi.addReceivedPDO(cobId);
    }

    @Override
    @Command
    public void clearReceivedPDOs() throws DriverException {
        coi.clearReceivedPDOs();
    }

    @Override
    @Command
    public PDOData sync() throws DriverException {
        return coi.sync();
    }

    @Override
    @Command
    public int scan() throws DriverException {
        return coi.scan();
    }

    @Override
    @Command
    public String info(int nodeID) throws DriverException {
        return coi.info(nodeID);
    }

    @Override
    @Command
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {
        coi.wsdo(nodeId, index, subindex, size, data);
    }

    @Override
    @Command
    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        return coi.rsdo(nodeId, index, subindex);
    }

    @Override
    @Command
    public void ssta(int nodeId) throws DriverException {
        coi.ssta(nodeId);
    }

    @Override
    @Command
    public void ssto(int nodeId) throws DriverException {
        coi.ssto(nodeId);
    }

    @Override
    @Command
    public void reset(int nodeId) throws DriverException {
        coi.reset(nodeId);
    }

    @Override
    @Command
    public void quit() throws DriverException {
        coi.quit();
    }

    @Override
    @Command
    public void init() throws DriverException {
        coi.init();
    }

    @Override
    @Command
    public void start() throws DriverException {
        coi.start();
    }

    @Override
    @Command
    public void stop() throws DriverException {
        coi.stop();
    }

    @Override
    @Command
    public boolean isReady() throws DriverException {
        return coi.isReady();
    }

    @Override
    @Command
    public void setEmergencyMessageListener(EmergencyMessageListener eml) throws DriverException {
        coi.setEmergencyMessageListener(eml);
    }

    @Override
    @Command
    public void setBootMessageListener(BootMessageListener bml) throws DriverException {
        coi.setBootMessageListener(bml);
    }

    @Override
    @Command
    public void setSdoTimeout(long to) throws DriverException {
        coi.setSdoTimeout(to);
    }

    @Override
    @Command
    public void setPdoTimeout(long to) throws DriverException {
        coi.setPdoTimeout(to);
    }

    @Override
    @Command
    public void setNMTStateOperational(int nodeId) throws DriverException {

    }
}
