package org.lsst.ccs.drivers.canopenjni.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * Has to be in sync with CanOpenInterface. TO-DO : is there a better way ?
 * @author emarin
 */
public interface CanOpenRemoteInterface extends Remote {
    
    /**
     * Initialization of the master node. This command has to be issued first
     * for the subsequent one to be successful.
     *
     * @param master 1 for master, 0 for slave.
     * @param baud "125K","1M",...
     * @param busName the bus name (0 for can0, 1 for can1)
     * @param nodeID the nodeID
     * @throws java.rmi.RemoteException
     */
    public void init(int master, String baud, String busName, int nodeID) throws DriverException, RemoteException;
    
    /**
     * Configures the pdo with the given cob_id for reception on the master node.
     * @param cobId 
     * @throws java.rmi.RemoteException 
     */
    public void addReceivedPDO(int cobId) throws DriverException, RemoteException;
    
    public void clearReceivedPDOs() throws DriverException, RemoteException;
    
    /**
     * Sends a sync message on the CANBus and synchronously waits for the received 
     * PDO configured in the master to be received.
     * For it to work, all received PDOs configured on the master node must have 
     * a transmission type equal to Ox1, otherwise the behavior is undefined.
     * @return the PDOs.
     * @throws DriverException 
     * @throws java.rmi.RemoteException 
     */
    public PDOData sync() throws DriverException, RemoteException;
    
    /**
     * Sends a scan on the can bus.
     * @return 
     * @throws java.rmi.RemoteException 
     */
    public int scan() throws DriverException, RemoteException;
    
    /**
     * Returns the information for the given nodeID.
     * @param nodeID the node id
     * @return 
     * @throws org.lsst.ccs.drivers.commons.DriverException 
     */
    public String info(int nodeID) throws DriverException, RemoteException;
    
    /**
     * 
     * @param nodeId the node id
     * @param index the index
     * @param subindex the sub index
     * @param size the size
     * @param data the data
     * @throws DriverException 
     */
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException, RemoteException;
    
    /**
     * Read device entry
     * @param nodeId the node id
     * @param index the index
     * @param subindex the subindex
     * @return an unsigned long. Cast to int to treat it as signed, leave to long to treat it as unsigned
     * @throws org.lsst.ccs.drivers.commons.DriverException
     */
    public long rsdo(int nodeId, int index, int subindex) throws DriverException, RemoteException;
    
    /**
     * Slave start
     * @param nodeId
     */
    public void ssta(int nodeId) throws DriverException, RemoteException;
    
    /**
     * Slave stop
     * @param nodeId
     */
    public void ssto(int nodeId) throws DriverException, RemoteException;
    
    public void reset(int nodeId) throws DriverException, RemoteException;

    public void quit() throws DriverException, RemoteException;;
    
    // Lifecycle
    public void init() throws DriverException, RemoteException;
    
    public void start() throws DriverException, RemoteException;
    
    public void stop() throws DriverException, RemoteException;
    
    public boolean isReady() throws DriverException, RemoteException;
    
    // Call backs for asynchronous information
    public void setEmergencyMessageListener(EmergencyMessageRemoteListener eml) throws DriverException, RemoteException;
    
    public void setBootMessageListener(BootMessageRemoteListener bml) throws DriverException, RemoteException;
    
    public void setSdoTimeout(long to) throws DriverException, RemoteException;

	public void setNMTStateOperational(int nodeId) throws DriverException;
}
