package org.lsst.ccs.drivers.canopenjni;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *
 * @author emarin
 */
public class SDOException extends DriverException {
    private static final long serialVersionUID = 8240623538814819882L;

    private final int nodeID;

    private final int index;

    private final int subindex;
    
    private final int errCode;
    
    private final int abortCode;
    
    public SDOException(int nodeID, int index, int subindex, int errCode, int abortCode) {
        this("sdo exception", nodeID, index, subindex, errCode, abortCode);
    }
    
    public SDOException(String message, int nodeID, int index, int subindex, int errCode, int abortCode) {
        super(message);
        this.nodeID = nodeID;
        this.index = index;
        this.subindex = subindex;
        this.errCode = errCode;
        this.abortCode = abortCode;
    }
    
    public int getErrCode() {
        return errCode;
    }
    
    public int getAbortCode() {
        return abortCode;
    }
    
    @Override
    public String toString() {
        return super.toString() + " : nodeID=0x" + Integer.toHexString(nodeID)
                + ", index=0x" + Integer.toHexString(index)
                + ", subindex=0x" + Integer.toHexString(subindex)
                + ", errCode=0x" + Integer.toHexString(errCode)
                + ", abortCode=0x" + Integer.toHexString(abortCode);
    }
}
