package org.lsst.ccs.drivers.canopenjni.rmi;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.lsst.ccs.drivers.canopenjni.BootMessageListener;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.EmergencyMessageListener;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 *
 * @author emarin
 */
public class CanOpenRMIClient implements CanOpenInterface {
    
    private CanOpenRemoteInterface stub;
    
    private final String registryHostName;
    
    private final String bindName;
    
    /**
     * 
     * @param registryHostName
     * @param bindName bindName = canbus0 for autochanger and carousel / canbus1 for loader
     */
    public CanOpenRMIClient(String registryHostName, String bindName) {
        this.registryHostName = registryHostName;
        this.bindName = bindName;
    }
    
    @Override
    public void init(int master, String baud, String busName, int nodeID) throws DriverException {
        try {
            Registry registry = LocateRegistry.getRegistry(registryHostName);
            this.stub = (CanOpenRemoteInterface) registry.lookup(bindName);
            stub.init(master, baud, busName, nodeID);
        } catch (Exception ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void addReceivedPDO(int cobId) throws DriverException {
        try {
            stub.addReceivedPDO(cobId);
        } catch(RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void clearReceivedPDOs() throws DriverException {
        try {
            stub.clearReceivedPDOs();
        } catch (Exception ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public PDOData sync() throws DriverException {
        try {
            return stub.sync();
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public int scan() throws DriverException {
        try {
            return stub.scan();
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public String info(int nodeID) throws DriverException {
        try {
            return stub.info(nodeID);
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {
        try {
            stub.wsdo(nodeId, index, subindex, size, data);
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        try {
            return stub.rsdo(nodeId, index, subindex);
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void ssta(int nodeId) throws DriverException {
        try {
            stub.ssta(nodeId);
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void ssto(int nodeId) throws DriverException {
        try {
            stub.ssto(nodeId);
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void reset(int nodeId) throws DriverException {
        try {
            stub.reset(nodeId);
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void quit() throws DriverException {
        try {
            stub.quit();
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void init() throws DriverException {
        try {
            stub.init();
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void start() throws DriverException {
        try {
            stub.start();
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void stop() throws DriverException {
        try {
            stub.stop();
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public boolean isReady() throws DriverException {
        try {
            return stub.isReady();
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void setEmergencyMessageListener(EmergencyMessageListener eml) throws DriverException {
        try {
            stub.setEmergencyMessageListener(new EmergencyMessageRemoteListenerImpl(eml));
        } catch (RemoteException ex) {
            throw new DriverException(ex);
        }
    }
    
    @Override
    public void setBootMessageListener(BootMessageListener bml) throws DriverException {
        try {
            stub.setBootMessageListener(new BootMessageRemoteListenerImpl(bml));
        } catch (Exception ex) {
            throw new DriverException(ex);
        }
    }

    @Override
    public void setSdoTimeout(long to) throws DriverException {
        try {
            stub.setSdoTimeout(to);
        } catch (Exception ex) {
            throw new DriverException(ex);
        }
    }

    @Override
    public void setPdoTimeout(long to) throws DriverException {
        try {
            stub.setSdoTimeout(to);
        } catch (Exception ex) {
            throw new DriverException(ex);
        }
    }

}
