package org.lsst.ccs.drivers.canopenjni;

import org.lsst.ccs.command.annotations.Command;

/**
 * Base abstract class for a CANopen slave device.
 * @author emarin
 */
public abstract class CanopenSlave {
    
    protected final CanopenMaster master;
    protected final int nodeId;
    
    public CanopenSlave(CanopenMaster master, int nodeId) {
        this.master = master;
        this.nodeId = nodeId;
    }
    
    @Command
    public int getNodeId() {
        return nodeId;
    }
    
    /**
     * Asynchronous reception of boot-up messages.
     */
    public abstract void onBootup();
    
    /**
     * Asynchronous reception of CANopen emergency messages.
     * @param errCode error code
     * @param errReg error register
     */
    public abstract void onEmergencyMessage(int errCode, int errReg);
    
    /**
     * Updates this node's inputs with the received pdos.
     * @param cob_id of the received pdo
     * @param pdoVal content of the received pdo
     */
    protected abstract void updateWithPDO(int cob_id, long pdoVal);
    
    public abstract int[] getCobIds();
    
}
