package org.lsst.ccs.drivers.canopenjni.rmi;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.drivers.canopenjni.CanFestivalJNI;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * The object passed as stub.
 * @author emarin
 */
public class CanOpenRMIServer implements CanOpenRemoteInterface {

    private final CanOpenInterface delegate;
    
    public CanOpenRMIServer(CanOpenInterface coi) {
        this.delegate = coi;
    }
    
    @Override
    public void init(int master, String baud, String busName, int nodeID) throws DriverException {
        delegate.init(master, baud, busName, nodeID);
    }

    @Override
    public void addReceivedPDO(int cobId) throws DriverException {
        delegate.addReceivedPDO(cobId);
    }

    @Override
    public PDOData sync() throws DriverException {
        return delegate.sync();
    }

    @Override
    public int scan() throws DriverException{
        return delegate.scan();
    }

    @Override
    public String info(int nodeID) throws DriverException {
        return delegate.info(nodeID);
    }

    @Override
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {
        delegate.wsdo(nodeId, index, subindex, size, data);
    }

    @Override
    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        return delegate.rsdo(nodeId, index, subindex);
    }

    @Override
    public void ssta(int nodeId) throws DriverException {
        delegate.ssta(nodeId);
    }

    @Override
    public void ssto(int nodeId) throws DriverException {
        delegate.ssto(nodeId);
    }

    @Override
    public void reset(int nodeId) throws DriverException {
        delegate.reset(nodeId);
    }

    @Override
    public void quit() throws DriverException {
        delegate.quit();
    }

    @Override
    public void init() throws DriverException {
        delegate.init();
    }

    @Override
    public void start() throws DriverException {
        delegate.start();
    }

    @Override
    public void stop() throws DriverException {
        delegate.stop();
    }

    @Override
    public boolean isReady() throws DriverException {
        return delegate.isReady();
    }

    @Override
    public void setEmergencyMessageListener(EmergencyMessageRemoteListener eml) throws DriverException {
        delegate.setEmergencyMessageListener((nodeId, errCode, errReg) -> {
            try {
                eml.onEmergencyMessage(nodeId, errCode, errReg);
            } catch (RemoteException ex) {
                Logger.getLogger(CanOpenRMIServer.class.getName()).log(Level.SEVERE, "cannot call back emergency message listener", ex);
            }
        });
    }

    @Override
    public void setBootMessageListener(BootMessageRemoteListener bml) throws DriverException {
        delegate.setBootMessageListener((nodeId) -> {
            try {
                bml.onBootMessage(nodeId);
            } catch(RemoteException ex) {
                Logger.getLogger(CanOpenRMIServer.class.getName()).log(Level.SEVERE, "cannot call back boot message listener", ex);
            }
        });
    }
    
    public static void main(String[] args){
        try {

            // Bind the remote object's stub in the registry
            Registry registry = LocateRegistry.getRegistry();

            CanOpenRMIServer coiRMI = new CanOpenRMIServer(new CanFestivalJNI());
            
            CanOpenRemoteInterface stub = (CanOpenRemoteInterface) UnicastRemoteObject.exportObject(coiRMI, 0);

            registry.bind("CanOpen", stub);

            System.err.println("Server ready");
        } catch (Exception e) {
            System.err.println("Server exception: " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void clearReceivedPDOs() throws DriverException, RemoteException {
        delegate.clearReceivedPDOs();
    }

    @Override
    public void setTimeoutMillis(long to) throws DriverException, RemoteException {
        delegate.setTimeoutMillis(to);
    }
    
}
