package org.lsst.ccs.drivers.canopenjni;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *
 * @author emarin
 */
public class SDOException extends DriverException {
    private static final long serialVersionUID = 8240623538814819882L;
    
    private final int errCode;
    
    private final int abortCode;
    
    public SDOException(int errCode, int abortCode) {
        super("sdo exception");
        this.errCode = errCode;
        this.abortCode = abortCode;
    }
    
    public int getErrCode() {
        return errCode;
    }
    
    public int getAbortCode() {
        return abortCode;
    }
    
    @Override
    public String toString() {
        return super.toString() + " : errCode : " + Integer.toHexString(errCode) + ", abortCode : " + Integer.toHexString(abortCode);
    }
            
    
}
