package org.lsst.ccs.drivers.canopenjni;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.shell.JLineShell;

/**
 *
 * @author emarin
 */
public class TestDirectJNI {

    public static class DummySlave extends CanopenSlave {

        public DummySlave(CanopenMaster master, int nodeId) {
            super(master, nodeId);
        }

        @Override
        public void onBootup() {
            System.out.println("node " + Integer.toHexString(nodeId) + " bootup");
            System.out.flush();
        }

        @Override
        public void onEmergencyMessage(int errCode, int errReg) {
            System.out.println("emergency message for node " + Integer.toHexString(nodeId) + ", errcode : " + errCode
                    + ", errreg : " + errReg);
            System.out.flush();
        }

        @Override
        protected void updateWithPDO(int cob_id, long pdoVal) {
            System.out.println("updating " + Integer.toHexString(cob_id) + " : " + Long.toHexString(pdoVal));
            System.out.flush();
        }

        @Override
        public int[] getCobIds() {
            return new int[] { 0x280 };
        }
    }

    public static void main(String[] args) throws Exception {

        // Building the composite dictionary for this object
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();

        compositeSet.add(builder.buildCommandSet(new DelegatedCommands()));
        compositeSet.add(builder.buildCommandSet(new TestCommands()));
        JLineShell shell = new JLineShell(compositeSet);
        shell.run();
        System.exit(0);
    }

    public static ArrayList<CanOpenInterface> itf = new ArrayList<>();

    public static class DelegatedCommands {
        @Command
        public synchronized int create() throws Exception {
            // CanOpenInterface coi = new LelyCanOpen();
            CanOpenInterface coi = new SocketCanOpen();
            itf.add(coi);
            // coi.init(master, baud, busName, nodeID);
            return itf.size();
        }

        @Command
        public synchronized int init(int bus, String busName, int nodeID) throws Exception {
            itf.get(bus).init(1, "100", busName, nodeID);
            return itf.size();
        }

        @Command
        public void addReceivedPDO(int bus, int cobId) throws Exception {
            itf.get(bus).addReceivedPDO(cobId);
        }

        @Command
        public void clearReceivedPDOs(int bus) throws Exception {
            itf.get(bus).clearReceivedPDOs();
        }

        @Command
        public Set<Integer> getReceivedPDOs(int bus) {
            Set<Integer> r = itf.get(bus).getRegisteredPDOs();
            for (int i : r)
                System.out.print(String.format("%02x", i));
            System.out.println();
            return r;
        }

        @Command
        public String getLastBeat(int bus, int id) {
            Instant t = itf.get(bus).getLastBeat(id);
            return t == null ? "null" : t.toString();
        }

        @Command
        public int getLastState(int bus, int id) {
            return itf.get(bus).getLastState(id);
        }

        @Command
        public void addExpectedDevice(int bus, int id) {
            itf.get(bus).addSlave(id);
        }

        @Command
        public PDOData sync(int bus) throws Exception {
            PDOData data = itf.get(bus).sync();
            System.out.println("TestJNI PDO Data " + data.getClass() + " : " + data.toString());
            return data;
        }

        @Command
        public int scan(int bus) throws Exception {
            return itf.get(bus).scan();
        }

        @Command
        public String info(int bus, int nodeID) throws Exception {
            return itf.get(bus).info(nodeID);
        }

        @Command
        public void wsdo(int bus, int nodeId, int index, int subindex, int size, long data)
                throws Exception {
            itf.get(bus).wsdo(nodeId, index, subindex, size, data);
        }

        @Command
        public long rsdo(int bus, int nodeId, int index, int subindex)
                throws Exception {
            return itf.get(bus).rsdo(nodeId, index, subindex);
        }

        @Command
        public void setNMTStateOperational(int bus, int nodeId) throws Exception {
            itf.get(bus).setNMTStateOperational(nodeId);
        }

        @Command
        public void setNMTStatePreOperational(int bus, int nodeId) throws Exception {
            itf.get(bus).setNMTStatePreOperational(nodeId);
        }

        @Command
        public void setNMTStateStop(int bus, int nodeId) throws Exception {
            itf.get(bus).setNMTStateStop(nodeId);
        }

        @Command
        public void reset(int bus, int nodeId) throws Exception {
            itf.get(bus).resetNode(nodeId);
        }

        @Command
        public void quit(int bus) throws Exception {
            itf.get(bus).quit();
        }
    }

    public static class TestCommands {

        public TestCommands() {
        }

        @Command
        public void testRSDOTiming(int bus, int nodeId, int index, int subindex, int nThreads, int times,
                int intervalMillis, @Argument(defaultValue = "true") boolean sync,
                @Argument(defaultValue = "false") boolean showTraces) throws Exception {
            CountDownLatch latch = new CountDownLatch(nThreads);
            long start = System.currentTimeMillis();
            CanOpenInterface coi = itf.get(bus);
            for (int i = 0; i < nThreads; i++) {
                new Thread(() -> {
                    String name = Thread.currentThread().getName();
                    int count = 0;
                    for (int j = 0; j < times; j++) {
                        try {
                            coi.rsdo(nodeId, index, subindex);
                            if (showTraces) {
                                System.out.println("thread " + name + " sucess. count : " + count);
                            }
                            count++;
                            Thread.sleep(intervalMillis);
                        } catch (Exception ex) {
                            System.out
                                    .println("thread " + name + " exception. count : " + count + " : " + ex.toString());
                        }
                    }
                    System.out.println("thread " + name + " done. success count : " + count);
                    latch.countDown();
                }, "rsdo-" + i).start();
            }
            if (sync) {
                latch.await();
            }
            long t = System.currentTimeMillis() - start;
            System.out.println("all done in " + t + " ms.");
        }
    }
}
