package org.lsst.ccs.drivers.canopenjni;

import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import java.util.Properties;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import static java.time.format.DateTimeFormatter.ISO_LOCAL_DATE_TIME;

public class CanDump {
    public static void main(String[] args) throws Exception {
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        String itf = (String) props.getOrDefault("itf", "can0");
        System.out.println("dumping " + itf);
        CanSocket socket;
        CanSocket.CanInterface canIf;

        socket = new CanSocket(CanSocket.Mode.RAW);
        canIf = new CanSocket.CanInterface(socket, itf);
        socket.bind(canIf);

        File file = new File(LocalDateTime.now().format(ISO_LOCAL_DATE_TIME) + "_candump.log");

        try (PrintWriter pw = new PrintWriter(file)) {

            while (true) {
                try {
                    CanSocket.CanFrame f = socket.recv();

                    // vcan0 001 [2] 01 0B
                    // vcan0 182 [8] CD AB CD AB 78 56 34 12

                    String s = String.format("%-10s  %03x  [%d] ", itf, f.getCanId().getCanId_SFF(),
                            f.getData().length);
                    for (byte b : f.getData()) {
                        s += String.format("%02X ", b);
                    }
                    System.out.println(s);

                    s = String.format("%s,%d,%d", LocalDateTime.now().format(ISO_LOCAL_DATE_TIME), f.getCanId().getCanId_SFF(), f.getData().length);
                    for (byte b : f.getData()) {
                        int x = b;
                        if (x<0) x = x+256;
                        s += String.format(",%d", x);
                    }
                    pw.println(s);
                    pw.flush();
                } catch (IOException e) {
                }
            }
        }
    }
}
