/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.canopenjni;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.BootMessageListener;
import org.lsst.ccs.drivers.canopenjni.CallbackListener;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.ConcurrentCallException;
import org.lsst.ccs.drivers.canopenjni.EmergencyMessageListener;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.canopenjni.ReturnData;
import org.lsst.ccs.drivers.canopenjni.SDOData;
import org.lsst.ccs.drivers.canopenjni.SDOException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.utilities.logging.Logger;

public class CanFestivalJNI
implements CanOpenInterface {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.drivers.canopenjni");
    private long sdoTimeout = 5000L;
    private long pdoTimeout = 500L;
    int bus;
    String busName;
    private BootMessageListener bml = nodeId -> System.out.println("boot : " + Integer.toHexString(nodeId));
    private EmergencyMessageListener eml = (nodeId, errCode, errReg) -> System.out.println("emergency message for node 0x" + Integer.toHexString(nodeId) + " :(errCode 0x" + Integer.toHexString(errCode) + " errReg 0x" + Integer.toHexString(errReg) + ")");
    static Map<String, Integer> buses;

    @Override
    public void addReceivedPDO(int cobId) {
        this.addReceivedPDO(this.bus, cobId);
    }

    public native void addReceivedPDO(int var1, int var2);

    @Override
    public void clearReceivedPDOs() {
        this.clearReceivedPDOs(this.bus);
    }

    public native void clearReceivedPDOs(int var1);

    public static synchronized int getBus(String busName) {
        Integer bus = buses.get(busName);
        if (bus == null) {
            bus = buses.size();
            buses.put(busName, bus);
        }
        return bus;
    }

    @Override
    @Command
    public synchronized void init(int master, String baud, String busName, int nodeID) {
        this.busName = busName;
        this.bus = CanFestivalJNI.getBus(busName);
        this.init(master, baud, busName, this.bus, nodeID);
    }

    public native void init(int var1, String var2, String var3, int var4, int var5);

    @Override
    public void setEmergencyMessageListener(EmergencyMessageListener eml) {
        this.eml = eml;
    }

    private void onEmergencyMessage(int nodeid, int errCode, int errReg) {
        this.eml.onEmergencyMessage(nodeid, errCode, errReg);
    }

    @Override
    public void setBootMessageListener(BootMessageListener bml) {
        this.bml = bml;
    }

    private void onSlaveBootup(int nodeid) {
        this.bml.onBootMessage(nodeid);
    }

    @Override
    @Command
    public PDOData sync() throws DriverException, DriverTimeoutException, ConcurrentCallException {
        PDOData rd = new PDOData();
        long beginTime = System.currentTimeMillis();
        log.info((Object)"sync sent to CANbus");
        try {
            rd = (PDOData)new SyncCommandWrapper(this, (pdocb, r) -> this.syncAsync(this.bus, pdocb, (PDOData)r), (ReturnData)rd, () -> this.clearCallBack(0, 0), this.pdoTimeout).get();
            if (rd.errCode != 0) {
                throw new DriverException(String.valueOf(rd.errCode));
            }
        }
        catch (DriverTimeoutException ex) {
            log.info((Object)"sync timed out, returning partial PDO data", (Throwable)ex);
            rd.errCode = 153;
        }
        long duration = System.currentTimeMillis() - beginTime;
        log.info((Object)("data returned from CANbus after sync - duration = " + duration));
        return rd;
    }

    private native void syncAsync(int var1, CallbackListener var2, PDOData var3);

    @Override
    @Command
    public int scan() {
        return this.scan(this.bus);
    }

    public native int scan(int var1);

    @Override
    @Command
    @Deprecated
    public String info(int nodeID) throws DriverException {
        long serialNb;
        long revNumber;
        long productCode;
        long deviceType = this.rsdo(nodeID, 4096, 0);
        long vendorID = this.rsdo(nodeID, 4120, 1);
        if (vendorID == deviceType) {
            log.warning((Object)("error for vendor, has to read again for nodeID=0x" + Integer.toHexString(nodeID)));
            vendorID = this.rsdo(nodeID, 4120, 1);
        }
        if ((productCode = this.rsdo(nodeID, 4120, 2)) == vendorID) {
            log.warning((Object)("error for productCode, has to read again for nodeID=0x" + Integer.toHexString(nodeID)));
            productCode = this.rsdo(nodeID, 4120, 2);
        }
        if ((revNumber = this.rsdo(nodeID, 4120, 3)) == productCode) {
            log.warning((Object)("error for revNumber, has to be read again for nodeID=0x" + Integer.toHexString(nodeID)));
            revNumber = this.rsdo(nodeID, 4120, 3);
        }
        if ((serialNb = this.rsdo(nodeID, 4120, 4)) == revNumber) {
            log.warning((Object)("error for serialNb, has to be read again for nodeID=0x" + Integer.toHexString(nodeID)));
            serialNb = this.rsdo(nodeID, 4120, 4);
        }
        StringBuilder res = new StringBuilder("info," + nodeID);
        return res.append(",").append(Long.toHexString(deviceType)).append(",").append(Long.toHexString(vendorID)).append(",").append(Long.toHexString(productCode)).append(",").append(Long.toHexString(revNumber)).append(",").append(Long.toHexString(serialNb)).toString();
    }

    @Override
    @Command
    public synchronized void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException, DriverTimeoutException, ConcurrentCallException {
        ReturnData rd = new ReturnData();
        rd.nodeId = nodeId;
        rd.otherData = nodeId + ":" + index + "/" + subindex;
        new SyncCommandWrapper(this, (sdocb, r) -> {
            log.finest((Object)("> wsdo async 0x" + nodeId + " " + index + " " + subindex));
            this.wsdoAsync(this.bus, nodeId, index, subindex, size, data, sdocb, r);
            log.finest((Object)("< wsdo async 0x" + nodeId + " " + index + " " + subindex));
        }, rd, () -> {
            if (nodeId != rd.nodeId) {
                log.error((Object)("nodeid discrepency call " + nodeId + " return " + rd.nodeId));
            }
            log.finest((Object)("> wsdo clear " + nodeId + " " + index + " " + subindex + " ret " + rd.nodeId));
            this.clearCallBack(nodeId, 1);
        }, this.sdoTimeout).get();
        if (rd.errCode != 0) {
            throw new SDOException(rd.errCode, rd.abortCode);
        }
    }

    private native void wsdoAsync(int var1, int var2, int var3, int var4, int var5, long var6, CallbackListener var8, ReturnData var9);

    @Override
    @Command
    public synchronized long rsdo(int nodeId, int index, int subindex) throws DriverException, DriverTimeoutException, ConcurrentCallException {
        SDOData ret = new SDOData();
        ret.otherData = nodeId + ":" + index + "/" + subindex;
        ret.nodeId = nodeId;
        new SyncCommandWrapper(this, (sdocb, rd) -> {
            log.finest((Object)("> rsdo async " + nodeId + " " + index + " " + subindex));
            this.rsdoAsync(this.bus, nodeId, index, subindex, sdocb, rd);
            log.finest((Object)("< rsdo async " + nodeId + " " + index + " " + subindex + " rd" + rd.toString()));
        }, (ReturnData)ret, () -> {
            if (nodeId != ret.nodeId) {
                log.error((Object)("nodeid discrepency call " + nodeId + " return " + ret.nodeId));
            }
            log.finest((Object)("> rsdo clear " + nodeId + " " + index + " " + subindex + " ret " + ret.nodeId + " " + ret.data + " ret.errCode= " + ret.errCode + " ret.abortCode"));
            this.clearCallBack(nodeId, 0);
        }, this.sdoTimeout).get();
        if (ret.errCode != 0) {
            throw new SDOException(ret.errCode, ret.abortCode);
        }
        return ret.data;
    }

    private native void rsdoAsync(int var1, int var2, int var3, int var4, CallbackListener var5, ReturnData var6);

    @Override
    public void ssta(int nodeId) {
        this.ssta(this.bus, nodeId);
    }

    public native void ssta(int var1, int var2);

    @Override
    public void ssto(int nodeId) {
        this.ssto(this.bus, nodeId);
    }

    public native void ssto(int var1, int var2);

    @Override
    public void reset(int nodeId) {
        this.reset(this.bus, nodeId);
    }

    public native void reset(int var1, int var2);

    @Override
    public void quit() {
        this.quit(this.bus);
    }

    public native void quit(int var1);

    @Override
    public void init() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void setSdoTimeout(long sdoTimeout) {
        this.sdoTimeout = sdoTimeout;
    }

    @Override
    public void setPdoTimeout(long aPDOTimeout) {
        this.pdoTimeout = aPDOTimeout;
    }

    @Command
    public synchronized void clearCallBack(int nodeId, int rw) {
        this.clearCallBack(this.bus, nodeId, rw);
    }

    public synchronized native void clearCallBack(int var1, int var2, int var3);

    @Override
    @Command
    public synchronized void setNMTStateOperational(int nodeId) {
        this.setNMTStateOperational(this.bus, nodeId);
    }

    public synchronized native void setNMTStateOperational(int var1, int var2);

    static {
        System.out.println("**** Loading the library ");
        try {
            System.loadLibrary("canopenJNI");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("**** Done Loading the library ");
        buses = new HashMap<String, Integer>();
    }

    private class SyncCommandWrapper<T extends ReturnData> {
        private final CommandWithCallback<T> callable;
        private final AbortCallbackCommand abort;
        private final T rd;
        private final long to;
        final /* synthetic */ CanFestivalJNI this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        SyncCommandWrapper(CommandWithCallback<T> rd, T abortCommand, AbortCallbackCommand timeout, long l2) {
            void asyncCommand;
            this.this$0 = (CanFestivalJNI)l;
            this.callable = asyncCommand;
            this.rd = rd;
            this.abort = abortCommand;
            this.to = (long)timeout;
        }

        T get() throws DriverException {
            final ReentrantLock cblock = new ReentrantLock();
            final Condition cb = cblock.newCondition();
            CallbackListener sdoCB = new CallbackListener(){

                @Override
                public void callback() {
                    cblock.lock();
                    try {
                        log.finest((Object)" canbus callback");
                        cb.signalAll();
                    }
                    finally {
                        cblock.unlock();
                    }
                }
            };
            cblock.lock();
            try {
                this.callable.call(sdoCB, this.rd);
                while (!((ReturnData)this.rd).set) {
                    if (cb.await(this.to, TimeUnit.MILLISECONDS)) continue;
                    this.abort.abortCallback();
                    throw new DriverTimeoutException("command timeout : no response received after " + this.to + " milliseconds");
                }
                log.finest((Object)("< sdo end wait " + ((ReturnData)this.rd).nodeId + " " + ((ReturnData)this.rd).otherData + "[" + ((ReturnData)this.rd).toString() + "]"));
                T t = this.rd;
                return t;
            }
            catch (InterruptedException ex) {
                this.abort.abortCallback();
                throw new DriverException((Throwable)ex);
            }
            finally {
                cblock.unlock();
            }
        }
    }

    private static interface AbortCallbackCommand {
        public void abortCallback();
    }

    private static interface CommandWithCallback<T extends ReturnData> {
        public void call(CallbackListener var1, T var2);
    }
}

