/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.canopenjni;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.BootMessageListener;
import org.lsst.ccs.drivers.canopenjni.CallbackListener;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.EmergencyMessageListener;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.canopenjni.ReturnData;
import org.lsst.ccs.drivers.canopenjni.SDOData;
import org.lsst.ccs.drivers.canopenjni.SDOException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.utilities.logging.Logger;

public class CanFestivalJNI
implements CanOpenInterface {
    private static final Logger log = Logger.getLogger((String)"org.lssst.ccs.drivers.canopenjni");
    private long timeout = 5000L;
    private int index = 8192;
    private BootMessageListener bml = nodeId -> System.out.println("boot : " + nodeId);
    private EmergencyMessageListener eml = (nodeId, errCode, errReg) -> System.out.println("emergency message for " + nodeId + " :(" + errCode + ":" + errReg + ")");

    @Override
    @Command
    public void addReceivedPDO(int cobId) {
        if (this.index >= 8200) {
            log.warning((Object)"cannot add transmit pdos : max number of received pdos reached");
        } else {
            this.addReceivedPDO(cobId, this.index);
            ++this.index;
        }
    }

    private native void addReceivedPDO(int var1, int var2);

    @Override
    @Command
    public native void init(int var1, String var2, String var3, int var4);

    @Override
    public void setEmergencyMessageListener(EmergencyMessageListener eml) {
        this.eml = eml;
    }

    private void onEmergencyMessage(int nodeid, int errCode, int errReg) {
        this.eml.onEmergencyMessage(nodeid, errCode, errReg);
    }

    @Override
    public void setBootMessageListener(BootMessageListener bml) {
        this.bml = bml;
    }

    private void onSlaveBootup(int nodeid) {
        this.bml.onBootMessage(nodeid);
    }

    @Override
    @Command
    public PDOData sync() throws DriverException {
        PDOData rd = new PDOData();
        rd = (PDOData)new SyncCommandWrapper(this, (pdocb, r) -> this.syncAsync(pdocb, (PDOData)r), (ReturnData)rd).get();
        if (rd.errMsg != null && !rd.errMsg.isEmpty()) {
            throw new DriverException(rd.errMsg);
        }
        return rd;
    }

    private synchronized native void syncAsync(CallbackListener var1, PDOData var2);

    @Override
    @Command
    public native int scan();

    @Override
    @Command
    public String info(int nodeID) throws DriverException {
        long deviceType = this.rsdo(nodeID, 4096, 0);
        long vendorID = this.rsdo(nodeID, 4120, 1);
        long productCode = this.rsdo(nodeID, 4120, 2);
        long revNumber = this.rsdo(nodeID, 4120, 3);
        long serialNb = this.rsdo(nodeID, 4120, 4);
        StringBuilder res = new StringBuilder("info," + nodeID);
        return res.append(",").append(Long.toHexString(deviceType)).append(",").append(Long.toHexString(vendorID)).append(",").append(Long.toHexString(productCode)).append(",").append(Long.toHexString(revNumber)).append(",").append(Long.toHexString(serialNb)).toString();
    }

    @Override
    @Command
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {
        ReturnData rd = new ReturnData();
        rd = new SyncCommandWrapper(this, (sdocb, r) -> this.wsdoAsync(nodeId, index, subindex, size, data, sdocb, r), rd).get();
        if (rd.errMsg != null && !rd.errMsg.isEmpty()) {
            throw new DriverException(rd.errMsg);
        }
    }

    private synchronized native void wsdoAsync(int var1, int var2, int var3, int var4, long var5, CallbackListener var7, ReturnData var8);

    @Override
    @Command
    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        SDOData ret = new SDOData();
        new SyncCommandWrapper(this, (sdocb, rd) -> this.rsdoAsync(nodeId, index, subindex, sdocb, rd), (ReturnData)ret).get();
        if (ret.errMsg != null && !ret.errMsg.isEmpty()) {
            throw new SDOException(ret.errMsg);
        }
        return ret.data;
    }

    private synchronized native void rsdoAsync(int var1, int var2, int var3, CallbackListener var4, ReturnData var5);

    @Override
    public native void ssta(int var1);

    @Override
    public native void ssto(int var1);

    @Override
    public native void reset(int var1);

    @Override
    public native void quit();

    @Override
    public void init() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Command
    public void setTimeoutMillis(long to) {
        this.timeout = to;
    }

    @Command
    public synchronized native void clearCallBack();

    static {
        System.out.println("**** Loading the library ");
        try {
            System.loadLibrary("canopenJNI");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("**** Done Loading the library ");
    }

    private static class SyncCommandWrapper<T extends ReturnData> {
        private final CommandWithCallback callable;
        private final T rd;
        final /* synthetic */ CanFestivalJNI this$0;

        SyncCommandWrapper(CommandWithCallback<T> asyncCommand, T rd) {
            this.this$0 = var1_1;
            this.callable = asyncCommand;
            this.rd = rd;
        }

        T get() throws DriverException {
            final ReentrantLock cblock = new ReentrantLock();
            final Condition cb = cblock.newCondition();
            CallbackListener sdoCB = new CallbackListener(){

                @Override
                public void callback() {
                    cblock.lock();
                    try {
                        cb.signalAll();
                    }
                    finally {
                        cblock.unlock();
                    }
                }
            };
            cblock.lock();
            try {
                this.callable.call(sdoCB, this.rd);
                while (!((ReturnData)this.rd).set) {
                    if (cb.await(this.this$0.timeout, TimeUnit.MILLISECONDS)) continue;
                    this.this$0.clearCallBack();
                    throw new DriverTimeoutException("command timeout");
                }
            }
            catch (InterruptedException ex) {
                this.this$0.clearCallBack();
                throw new DriverException("interrupted", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new DriverException((Throwable)ex);
            }
            finally {
                cblock.unlock();
            }
            return this.rd;
        }
    }

    private static interface CommandWithCallback<T extends ReturnData> {
        public void call(CallbackListener var1, T var2);
    }
}

