package org.lsst.ccs.drivers.canopenjni.rmi;

import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.drivers.canopenjni.CanOpenCommands;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.shell.JLineShell;

/**
 * A test RMI Client.
 * @author emarin
 */
public class TestRMIClient {

    private TestRMIClient() {}

    public static void main(String[] args) {

        String host = (args.length < 1) ? null : args[0];
        System.out.println("will connect to " + host);
        try {
            
            CanOpenInterface coi = new CanOpenRMIClient(host);
            
            // Building the composite dictionary for this object
            CommandSetBuilder builder = new CommandSetBuilder();
            CompositeCommandSet compositeSet = new CompositeCommandSet();
            
            compositeSet.add(builder.buildCommandSet(new CanOpenCommands(coi)));
            JLineShell shell = new JLineShell(compositeSet);
            shell.run();
            System.exit(0);        
            
        } catch (Exception e) {
            System.err.println("Client exception: " + e.toString());
            e.printStackTrace();
        }
        
    }
    
}
