package org.lsst.ccs.drivers.canopenjni;

import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.shell.JLineShell;

/**
 *
 * @author emarin
 */
public class TestDirectJNI {
    
    
    public static class DummySlave extends CanopenSlave {
        
        public DummySlave(CanopenMaster master, int nodeId) {
            super(master, nodeId);
        }

        @Override
        public void onBootup() {
            System.out.println("node " + Integer.toHexString(nodeId) + " bootup");
            System.out.flush();
        }

        @Override
        public void onEmergencyMessage(int errCode, int errReg) {
            System.out.println("emergency message for node " + Integer.toHexString(nodeId) + ", errcode : " + errCode + ", errreg : " + errReg);
            System.out.flush();
        }

        @Override
        protected void updateWithPDO(int cob_id, long pdoVal) {
            System.out.println("updating " + Integer.toHexString(cob_id) + " : " + Long.toHexString(pdoVal));
            System.out.flush();
        }

        @Override
        public int[] getCobIds() {
            return new int[]{0x280};
        }
    }
    
    public static void main(String [] args) throws Exception {
        
        CanOpenInterface coi = new CanFestivalJNI();
        
        // Building the composite dictionary for this object
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        
        compositeSet.add(builder.buildCommandSet(coi));
        JLineShell shell = new JLineShell(compositeSet);
        shell.run();
        System.exit(0);        
    }
    
}
