package org.lsst.ccs.drivers.canopenjni;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *
 * @author emarin
 */
public class SDOException extends DriverException {
    private static final long serialVersionUID = 8240623538814819882L;
    
    private final String errCode;
    
    public SDOException(String errCode) {
        super(errCode);
        this.errCode = errCode;
    }
    
    public SDOException(String errCode, String message, Throwable e) {
        super(message + ". errCode : " + errCode, e);
        this.errCode = errCode;
    }

    public SDOException(String errCode, String message) {
        super(message + ". errCode : " + errCode);
        this.errCode = errCode;
        
    }

    public SDOException(String errCode, Throwable e) {
        super("errCode : " + errCode, e);
        this.errCode = errCode;
    }

    public String getErrCode() {
        return errCode;
    }
    
}
