package org.lsst.ccs.drivers.canopenjni;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author emarin
 */
public class PDOData extends ReturnData implements Serializable {
    private static final long serialVersionUID = 5276705461745810730L;

    protected final Map<Integer, Long> pdos = new HashMap<>();
    
    public void updatePDO(int index, long value) {
        pdos.put(index, value);
    }
    
    public Map<Integer, Long> getPDOs() {
        return pdos;
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append(" ");
        for(Map.Entry<Integer, Long> entry : pdos.entrySet()) {
            sb.append(Integer.toHexString(entry.getKey()))
                    .append(" -> ")
                    .append(Long.toHexString(entry.getValue()))
                    .append("\n");
        }
        return sb.toString();
    }
    
}
