package org.lsst.ccs.drivers.canopen;

public interface IMasterDevice {
	
	/**
	 * A canopen master device can ask its NMT state to another device on the network.
	 * @param nodeID If nodeID=0 this request is sent to all the devices on the network.
	 * @return the device NMT state
	 */
	NMTState requestNodeState(int nodeID);	
	void changeNMTState(int nodeID, NMTState nmtState);
	
	void monitorNetwork();

}
