package org.lsst.ccs.drivers.canopen;

public interface ICanOpenDevice {
	
	void init();
	void initFromEDS(String edsFile);	
	
	public NMTState getNmtState();
	public void setNmtState(NMTState nmtState);
	
	void readFromCanBus();	
	void writeOnCanBus(CanOpenMessage message);

	void sendHeartBeatMessage();
	void sendBootMessage();
	
	
	/**
	 * A CanOpen device must implement a Service Data Objects, SDO
	 * @param nodeID
	 * @param request
	 */	
	void sendSDORequestToServerOD(int nodeID,SDORequest request);
	SDOResponse receiveSDOResponseFromServer(int nodeID);
	
	SDORequest receiveSDORequestFromClient(int nodeID);	
	void sendSDOResponseToClient(int nodeID, SDOResponse response);
	
	/**
	 * A CanOpen device may support transmission or receipt of Process Date Objects, PDO
	 */
	void buildPDO();
	void transmitPDO();
	void receivePDO();
	
	/**
	 * A can Open Device may support some special functions
	 */
	void sendSyncMessage();
	void sendEmergencyMessage();
	void onEmergencyMessage();
	void sendTimeStampMessage();
	void onTimeStampMessage();
	

}
