package org.lsst.ccs.drivers.canopen;

/**
 * Messages in the Can Open protocol.
 * This messages are to be included in a Data Frame or Remote Frame 
 * by the CanBus driver to be sent on a Can bus.
 * @author virieux
 *
 */
public abstract class CanOpenMessage {
	
	/**
	 * The arbitration field of a CanBus Frame is composed of :
	 * cob + nodeID + rtr 
	 *
	 */
	
	/** Communication OBject or function code on 4 bits.*/
	int cob;
	
	/** node identifier on 7 bits */
	int nodeId;
	
	/** Remote Transmission Request bit 
	 * rtr=0 for a Data Frame / rtr=1 for a Remote Frame
	 * */
	boolean rtr;
	
	/**
	 * number of bytes in the data field (4 bits)
	 * Part of the Can Bus Control Field on a CanBus Frame.
	 */
	short length;
	
	/** data field, 0...8 bytes 
	 *  This is the data field in a Can Bus Data Frame.
	 */	
	byte[] data;

	public CanOpenMessage(int cob, int nodeId, boolean rtr, short length,
			byte[] data) {
		super();
		this.cob = cob;
		this.nodeId = nodeId;
		this.rtr = rtr;
		this.length = length;
		this.data = data;
	}
	
	

}
