package org.lsst.ccs.drivers.canbus;

import java.io.Serializable;
import java.util.Date;

public class CanMessage implements Serializable {
	// static final int CAN_MSG_LENGTH = 8;

	/* flags */
	/** RTR Message */
	static final int MSG_RTR = (1 << 0);
	/** CAN controller Msg overflow error */
	static final int MSG_OVR = (1 << 1);
	/** extended message format */
	static final int MSG_EXT = (1 << 2);
	/** message received from own tx */
	static final int MSG_SELF = (1 << 3);
	/** controller in error passive */
	static final int MSG_PASSIVE = (1 << 4);
	/** controller Bus Off */
	static final int MSG_BUSOFF = (1 << 5);
	/** CAN Warning Level reached */
	static final int MSG_WARNING = (1 << 6);
	/** receive/transmit buffer overflow */
	static final int MSG_BOVR = (1 << 7);

	/* valid bits in CAN ID for frame formats */
	/** standard frame format (SFF) */
	static final long CAN_SFF_MASK = 0x000007FF;
	/** extended frame format (EFF) */
	static final long CAN_EFF_MASK = 0x1FFFFFFF;
	/** invalid CAN ID == Error */
	static final long CANDRIVERERROR = 0xFFFFFFFF;

	int flags;
	/** CAN object number */
	int cob;
	/** CAN message ID, 4 bytes */
	long id;
	/** time stamp for received messages */
	Date timestamp;
	/** number of bytes in the CAN message */
	short length;
	/** data, 0...8 bytes */
	byte[] data;

}
