package org.lsst.ccs.drivers.bonnshutter;

import java.util.List;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * Simple interactive test program
 * @author tonyj
 */
public class TestBonnShutter {
    private final BonnShutter shutter = new BonnShutter();

    @Command(name="open", description="Open connection to the Bonn Shutter")
    public void open(String device) throws DriverException {
        shutter.open(device);
    }

    @Command(name="close", description="Close connection to the Bonn Shutter")
    public void close() throws DriverException {
        shutter.close();
    }

    @Command(name="getVersion")
    public String getVersion() throws DriverException {
        return shutter.getVersion();
    }

    @Command(name="getMotorFirmwareVersion")
    public List<String> getMotorFirmwareVersion() throws DriverException {
        return shutter.getMotorFirmwareVersion();
    }

    @Command(name="getVerboseVelocityProfileParameters")
    public List<String> getVerboseVelocityProfileParameters() throws DriverException {
        return shutter.getVerboseVelocityProfileParameters();
    }

    @Command(name="getVelocityProfileParameters")
    public BonnShutter.ProfileParameters getVelocityProfileParameters() throws DriverException {
        return shutter.getVelocityProfileParameters();
    }

    @Command(name="getOpenCloseStatus")
    public BonnShutter.OpenCloseStatus getOpenCloseStatus() throws DriverException {
        return shutter.getOpenCloseStatus();
    }
    
    @Command(name="openShutter")
    public void openShutter() throws DriverException {
        shutter.openShutter();
    }

    @Command
    public void closeShutter() throws DriverException {
        shutter.closeShutter();
    }

    @Command
    public void expose(int exposeMillis) throws DriverException {
        shutter.expose(exposeMillis);
    }

   @Command
    public void exposeSeries(int n, int exposeMillis, int waitMillis) throws DriverException {
        shutter.exposeSeries(n, exposeMillis, waitMillis);
    }

    @Command
    public void reset() throws DriverException {
        shutter.reset();
    }

    @Command
    public BonnShutter.Voltages getVoltages() throws DriverException {
        return shutter.getVoltages();
    }

    @Command
    public void moveAbsolute(BonnShutter.Blade blade, int velocity, int position) throws DriverException {
        shutter.moveAbsolute(blade, velocity, position);
    }

    @Command
    public void moveRelative(BonnShutter.Blade blade, int velocity, int position) throws DriverException {
        shutter.moveRelative(blade, velocity, position);
    }

    @Command
    public String getMotorPosition(BonnShutter.Blade blade) throws DriverException {
        return shutter.getMotorPosition(blade);
    }

    @Command
    public List<String> executeGenericCommand(String command) throws DriverException {
        return shutter.executeGenericCommand(command);
    }
    
    
}
