/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.bk;

import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.drivers.scpi.Scpi;

public class XLNSeries
extends Scpi
implements PowerSupplyDriver {
    public static final int DEFAULT_BAUDRATE = 57600;
    public static final int DEFAULT_PORT = 5025;
    public static final int STATUS_LCD_ON = 2;
    public static final int STATUS_OUTPUT_ON = 4;
    public static final int STATUS_CVCC_ENAB = 8;
    public static final int STATUS_CCCV_ENAB = 16;
    public static final int STATUS_OPP_ENAB = 32;
    public static final int STATUS_OCP_ENAB = 64;
    public static final int STATUS_OVP_ENAB = 128;
    public static final int STATUS_OTP = 512;
    public static final int STATUS_AC_LOW = 1024;
    public static final int STATUS_CVCC = 2048;
    public static final int STATUS_CCCV = 4096;
    public static final int STATUS_OPP = 8192;
    public static final int STATUS_OCP = 16384;
    public static final int STATUS_OVP = 32768;
    private final Timer timer = new Timer("Timer_XLN", true);
    private long onDelay = 0L;
    private long offDelay = 0L;
    private SetOutput outTask;

    public XLNSeries() {
        this.setDefaultBaud(57600);
        this.setDefaultPort(5025);
    }

    public void open(DriverConstants.ConnType connType, String ident, int connParm, int commParm) throws DriverException {
        super.open(connType, ident, 0, 0);
        this.setTerminator(Ascii.Terminator.CRLF);
        try {
            this.checkIdentification("B&K PRECISION", 0, "XLN", 1);
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void setOutput(boolean on, int chan) throws DriverException {
        long delay = on ? this.onDelay : this.offDelay;
        String command = "OUT " + (on ? "ON" : "OFF");
        SetOutput task = this.outTask;
        if (task != null) {
            task.cancel();
            this.outTask = null;
        }
        if (delay == 0L) {
            this.writeCommand(command);
        } else {
            this.outTask = new SetOutput(command);
            this.timer.schedule((TimerTask)this.outTask, delay);
        }
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.readString("OUT?").equals("ON");
    }

    public void setOnDelay(double time, int chan) throws DriverException {
        this.onDelay = (long)(1000.0 * time);
    }

    public void setOffDelay(double time, int chan) throws DriverException {
        this.offDelay = (long)(1000.0 * time);
    }

    public void setVoltage(double value, int chan) throws DriverException {
        this.writeCommand("VOLT " + value);
    }

    public double getVoltage(int chan) throws DriverException {
        return this.readDouble("VOLT?");
    }

    public double readVoltage(int chan) throws DriverException {
        return this.readDouble("MEAS:VOLT?");
    }

    public void setCurrent(double value, int chan) throws DriverException {
        this.writeCommand("CURR " + value);
    }

    public double getCurrent(int chan) throws DriverException {
        return this.readDouble("CURR?");
    }

    public double readCurrent(int chan) throws DriverException {
        return this.readDouble("MEAS:CURR?");
    }

    public void setVoltageLimit(double value, int chan) throws DriverException {
        this.writeCommand("OUT:LIM:VOLT" + value);
    }

    public double getVoltageLimit(int chan) throws DriverException {
        return this.readDouble("OUT:LIM:VOLT?");
    }

    public void setCurrentLimit(double value, int chan) throws DriverException {
        this.writeCommand("OUT:LIM:CURR" + value);
    }

    public double getCurrentLimit(int chan) throws DriverException {
        return this.readDouble("OUT:LIM:CURR?");
    }

    public int getStatusWord() throws DriverException {
        try {
            return Integer.valueOf(this.readString("STATUS?"), 16);
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public void lockPanel(boolean lock) throws DriverException {
        this.writeCommand("SYS:KEY:LOCK " + (lock ? 1 : 0));
    }

    protected void checkError() throws DriverException {
        try {
            int error = Integer.valueOf(this.getError());
            if (error == 0) {
                return;
            }
            throw new DriverException("SCPI error: " + error + ": " + (switch (error) {
                case 1 -> "Unknown command";
                case 2 -> "Execution failed";
                case 3 -> "Query failed";
                case 4 -> "Parameter out of range";
                default -> "Unexpected error";
            }));
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public int getEventStatusEnable() {
        return 0;
    }

    public int getEventStatus() {
        return 0;
    }

    public int getServiceRequestEnable() {
        return 0;
    }

    public int getStatusByte() {
        return 0;
    }

    public int getOperationComplete() {
        return 0;
    }

    class SetOutput
    extends TimerTask {
        private final String command;

        SetOutput(String command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                XLNSeries.this.writeCommand(this.command);
            }
            catch (DriverException driverException) {
                // empty catch block
            }
            XLNSeries.this.outTask = null;
        }
    }
}

