/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.bk;

import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.drivers.scpi.Scpi;

public class Model9130
extends Scpi
implements PowerSupplyDriver {
    public static final int DEFAULT_BAUDRATE = 9600;
    public static final int MIN_CHANNEL = 1;
    public static final int MAX_CHANNEL = 3;
    public static final int NUM_CHANNELS = 3;
    public static final double MAX_VALUE = Double.POSITIVE_INFINITY;
    private final Timer timer = new Timer("Timer_9130", true);
    private final long[] onDelay = new long[3];
    private final long[] offDelay = new long[3];
    private final SetOutput[] outTask = new SetOutput[3];

    public Model9130() {
        super(Ascii.Option.NO_NET);
    }

    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int commParm) throws DriverException {
        super.open(connType, ident, baudRate == 0 ? 9600 : baudRate, commParm);
        try {
            this.checkIdentification("BK", 0, "9130", 0);
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(DriverConstants.ConnType connType, String ident) throws DriverException {
        this.open(connType, ident, 0);
    }

    @Deprecated
    public void open(int connType, String ident) throws DriverException {
        this.open(connType, ident, 0);
    }

    public void setOutput(boolean on, int chan) throws DriverException {
        this.checkChannel(chan);
        int index = chan - 1;
        long delay = on ? this.onDelay[index] : this.offDelay[index];
        String command = "OUTP " + (on ? "1" : "0");
        SetOutput task = this.outTask[index];
        if (task != null) {
            task.cancel();
            this.outTask[index] = null;
        }
        if (delay == 0L) {
            this.writeChan(command, chan);
        } else {
            this.outTask[index] = new SetOutput(command, chan);
            this.timer.schedule((TimerTask)this.outTask[index], delay);
        }
    }

    public void setOutput(boolean[] on) throws DriverException {
        int j;
        if (on.length != 3) {
            throw new DriverException("Invalid value array size");
        }
        boolean delay = false;
        for (j = 0; j < 3; ++j) {
            if ((on[j] ? this.onDelay[j] : this.offDelay[j]) == 0L) continue;
            delay = true;
        }
        if (!delay) {
            StringBuilder str = new StringBuilder();
            for (int j2 = 0; j2 < on.length; ++j2) {
                if (j2 != 0) {
                    str.append(",");
                }
                str.append(on[j2] ? "1" : "0");
            }
            this.writeCommand("APP:OUT " + str);
        } else {
            for (j = 0; j < 3; ++j) {
                this.setOutput(on[j], 1 + j);
            }
        }
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.readIntegerChan("OUTP?", chan) != 0;
    }

    public boolean[] getOutput() throws DriverException {
        int[] iState = this.readIntegerArray("APP:OUT?");
        boolean[] state = new boolean[iState.length];
        for (int j = 0; j < state.length; ++j) {
            state[j] = iState[j] != 0;
        }
        return state;
    }

    public void setOnDelay(double time, int chan) throws DriverException {
        this.checkChannel(chan);
        this.onDelay[chan - 1] = (long)(1000.0 * time);
    }

    public void setOffDelay(double time, int chan) throws DriverException {
        this.checkChannel(chan);
        this.offDelay[chan - 1] = (long)(1000.0 * time);
    }

    public void setVoltage(double value, int chan) throws DriverException {
        this.writeChan("VOLT " + (Double.isFinite(value) ? Double.valueOf(value) : "MAX"), chan);
    }

    public void setVoltage(double[] values) throws DriverException {
        this.writeCommand("APP:VOLT " + this.makeString(values));
    }

    public double getVoltage(int chan) throws DriverException {
        return this.readDoubleChan("VOLT?", chan);
    }

    public double[] getVoltage() throws DriverException {
        return this.readDoubleArray("APP:VOLT?");
    }

    public double getMaximumVoltage(int chan) throws DriverException {
        return this.readDoubleChan("VOLT? MAX", chan);
    }

    public double[] getMaximumVoltage() throws DriverException {
        return this.readDoubleArray("APP:VOLT? MAX");
    }

    public double readVoltage(int chan) throws DriverException {
        return this.readDoubleChan("MEAS:VOLT?", chan);
    }

    public double[] readVoltage() throws DriverException {
        return this.readDoubleArray("MEAS:VOLT:ALL?");
    }

    public void setCurrent(double value, int chan) throws DriverException {
        this.writeChan("CURR " + (Double.isFinite(value) ? Double.valueOf(value) : "MAX"), chan);
    }

    public void setCurrent(double[] values) throws DriverException {
        this.writeCommand("APP:CURR " + this.makeString(values));
    }

    public double getCurrent(int chan) throws DriverException {
        return this.readDoubleChan("CURR?", chan);
    }

    public double[] getCurrent() throws DriverException {
        return this.readDoubleArray("APP:CURR?");
    }

    public double getMaximumCurrent(int chan) throws DriverException {
        return this.readDoubleChan("CURR? MAX", chan);
    }

    public double[] getMaximumCurrent() throws DriverException {
        return this.readDoubleArray("APP:CURR? MAX");
    }

    public double readCurrent(int chan) throws DriverException {
        return this.readDoubleChan("MEAS:CURR?", chan);
    }

    public double[] readCurrent() throws DriverException {
        return this.readDoubleArray("MEAS:CURR:ALL?");
    }

    public void setVoltageLimit(double value, int chan) throws DriverException {
        this.writeChan("VOLT:PROT " + (Double.isFinite(value) ? Double.valueOf(value) : "MAX"), chan);
    }

    public void setVoltageLimit(double[] values) throws DriverException {
        this.writeCommand("APP:PROT " + this.makeString(values));
    }

    public double getVoltageLimit(int chan) throws DriverException {
        return this.readDoubleChan("VOLT:PROT?", chan);
    }

    public double[] getVoltageLimit() throws DriverException {
        return this.readDoubleArray("APP:PROT?");
    }

    public void lockPanel(boolean lock) throws DriverException {
        this.writeCommand(lock ? "SYST:RWL" : "SYST:LOC");
    }

    private void checkChannel(int chan) throws DriverException {
        if (chan < 1 || chan > 3) {
            throw new DriverException("Invalid channel number");
        }
    }

    private void writeSelect(int chan) throws DriverException {
        this.checkChannel(chan);
        this.writeCommand("INST:NSEL " + chan);
    }

    private synchronized void writeChan(String instr, int chan) throws DriverException {
        this.writeSelect(chan);
        this.writeCommand(instr);
    }

    private synchronized double readDoubleChan(String instr, int chan) throws DriverException {
        this.writeSelect(chan);
        return this.readDouble(instr);
    }

    private synchronized int readIntegerChan(String instr, int chan) throws DriverException {
        this.writeSelect(chan);
        return this.readInteger(instr);
    }

    private String makeString(double[] values) throws DriverException {
        if (values.length != 3) {
            throw new DriverException("Invalid value array size");
        }
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < values.length; ++j) {
            if (j != 0) {
                str.append(",");
            }
            str.append(Double.isFinite(values[j]) ? Double.valueOf(values[j]) : "MAX");
        }
        return str.toString();
    }

    class SetOutput
    extends TimerTask {
        private final int chan;
        private final String command;

        SetOutput(String command, int chan) {
            this.command = command;
            this.chan = chan;
        }

        @Override
        public void run() {
            try {
                Model9130.this.writeChan(this.command, this.chan);
            }
            catch (DriverException driverException) {
                // empty catch block
            }
            ((Model9130)Model9130.this).outTask[this.chan - 1] = null;
        }
    }
}

