/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.bk;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.bk.Model9130;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class Test9130
extends TestScpi {
    private final Model9130 bk = (Model9130)this.scpi;
    private int chanNum = 1;

    public Test9130() {
        super(new Model9130());
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") DriverConstants.ConnType connType, @Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.bk.open(connType, ident);
    }

    @Command(name="setchannel", description="Set the current channel")
    public void setChannel(@Argument(name="channel", description="Channel number") int chan) {
        this.chanNum = chan;
    }

    @Command(name="showchannel", description="Show the set channel")
    public String showChannel() {
        return "Channel = " + this.chanNum;
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.bk.setVoltage(value, this.chanNum);
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.bk.setVoltage(value, chan);
    }

    @Command(name="setvoltages", description="Set all the voltages")
    public void setVoltages(double ... values) throws DriverException {
        this.bk.setVoltage(values);
    }

    @Command(name="setmaxvoltage", description="Set the voltage to maximum")
    public void setMaxVoltage() throws DriverException {
        this.bk.setVoltage(Double.POSITIVE_INFINITY, this.chanNum);
    }

    @Command(name="setmaxvoltage", description="Set the voltage to maximum")
    public void setMaxVoltage(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.bk.setVoltage(Double.POSITIVE_INFINITY, chan);
    }

    @Command(name="showmaxvoltage", description="Show the maximum voltage")
    public String showMaxVoltage() throws DriverException {
        return "Maximum voltage = " + this.bk.getMaximumVoltage(this.chanNum);
    }

    @Command(name="showmaxvoltage", description="Show the maximum voltage")
    public String showMaxVoltage(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Maximum voltage = " + this.bk.getMaximumVoltage(chan);
    }

    @Command(name="showmaxvoltages", description="Show all the maximum voltages")
    public String showMaxVoltages() throws DriverException {
        return "Maximum voltages = " + this.getString(this.bk.getMaximumVoltage());
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String showVoltage() throws DriverException {
        return "Voltage = " + this.bk.getVoltage(this.chanNum);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String showVoltage(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Voltage = " + this.bk.getVoltage(chan);
    }

    @Command(name="showvoltages", description="Show all the set voltages")
    public String showVoltages() throws DriverException {
        return "Voltages = " + this.getString(this.bk.getVoltage());
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException {
        return "Voltage = " + this.bk.readVoltage(this.chanNum);
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Voltage = " + this.bk.readVoltage(chan);
    }

    @Command(name="readvoltages", description="Read all the actual voltages")
    public String readVoltages() throws DriverException {
        return "Voltages = " + this.getString(this.bk.readVoltage());
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        this.bk.setVoltageLimit(value, this.chanNum);
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.bk.setVoltageLimit(value, chan);
    }

    @Command(name="setvoltlims", description="Set all the voltage limits")
    public void setVoltlimits(double ... values) throws DriverException {
        this.bk.setVoltageLimit(values);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String showVoltageLimit() throws DriverException {
        return "Voltage limit = " + this.bk.getVoltageLimit(this.chanNum);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String showVoltageLimit(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Voltage limit = " + this.bk.getVoltageLimit(chan);
    }

    @Command(name="showvoltlims", description="Show all the soft voltage limits")
    public String showVoltageLimits() throws DriverException {
        return "Voltage limits = " + this.getString(this.bk.getVoltageLimit());
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) throws DriverException {
        this.bk.setCurrent(value, this.chanNum);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.bk.setCurrent(value, chan);
    }

    @Command(name="setcurrents", description="Set all the currents")
    public void setCurrents(double ... values) throws DriverException {
        this.bk.setCurrent(values);
    }

    @Command(name="setmaxcurrent", description="Set the current to maximum")
    public void setMaxCurrent() throws DriverException {
        this.bk.setVoltage(Double.POSITIVE_INFINITY, this.chanNum);
    }

    @Command(name="setmaxcurrent", description="Set the current to maximum")
    public void setMaxCurrent(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.bk.setVoltage(Double.POSITIVE_INFINITY, chan);
    }

    @Command(name="showmaxcurrent", description="Show the set current")
    public String showMaxCurrent() throws DriverException {
        return "Maximum current = " + this.bk.getMaximumCurrent(this.chanNum);
    }

    @Command(name="showmaxcurrent", description="Show the set current")
    public String showMaxCurrent(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Maximum current = " + this.bk.getMaximumCurrent(chan);
    }

    @Command(name="showmaxcurrents", description="Show all the maximum currents")
    public String showMaxCurrents() throws DriverException {
        return "Maximum currents = " + this.getString(this.bk.getMaximumCurrent());
    }

    @Command(name="showcurrent", description="Show the set current")
    public String showCurrent() throws DriverException {
        return "Current = " + this.bk.getCurrent(this.chanNum);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String showCurrent(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Current = " + this.bk.getCurrent(chan);
    }

    @Command(name="showcurrents", description="Show the set current")
    public String showCurrents() throws DriverException {
        return "Currents = " + this.getString(this.bk.getCurrent());
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException {
        return "Current = " + this.bk.readCurrent(this.chanNum);
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Current = " + this.bk.readCurrent(chan);
    }

    @Command(name="readcurrents", description="Read the actual current")
    public String readCurrents() throws DriverException {
        return "Current = " + this.getString(this.bk.readCurrent());
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") OnOff state) throws DriverException {
        this.bk.setOutput(state == OnOff.ON, this.chanNum);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") OnOff state, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.bk.setOutput(state == OnOff.ON, chan);
    }

    @Command(name="setoutputs", description="Set all the output states")
    public void setOutputs(OnOff ... states) throws DriverException {
        boolean[] bstates = new boolean[states.length];
        for (int j = 0; j < bstates.length; ++j) {
            bstates[j] = states[j] == OnOff.ON;
        }
        this.bk.setOutput(bstates);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + this.getOnOff(this.bk.getOutput(this.chanNum));
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Output state = " + this.getOnOff(this.bk.getOutput(chan));
    }

    @Command(name="showoutputs", description="Show the output state")
    public String showOutputs() throws DriverException {
        return "Output states = " + this.getString(this.bk.getOutput());
    }

    @Command(name="lock", description="Lock the front panel")
    public void lock() throws DriverException {
        this.bk.lockPanel(true);
    }

    @Command(name="unlock", description="Unlock the front panel")
    public void unlock() throws DriverException {
        this.bk.lockPanel(false);
    }

    private StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }

    private StringBuilder getString(boolean[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0] ? "on" : "off");
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j] ? "on" : "off");
        }
        return text;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum OnOff {
        OFF,
        ON;

    }
}

