package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling the 24V clean SLAC PDU
 *
 *  @author  Owen Saxton
 */
public class ComCamPdu24VC extends PduHV {

    /**
     *  Constants and data.
     */
    public static final int
        CHAN_J5   = 0, // J5
        CHAN_J6   = 1, // J6
        CHAN_J7   = 2, // J7
        CHAN_J8   = 3,

        CHAN_J9   = 4,
        CHAN_BPU_MAQ20 = 5, // J10
        CHAN_J11  = 6,
        CHAN_J12  = 7,

        CHAN_J13  = 8,    
        CHAN_J14  = 9,
        CHAN_J15   = 10,
        CHAN_J16   = 11,
        NUM_CHANS          = 12;

    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
        CHANNEL_MAP.put("v24cj5", CHAN_J5);
        CHANNEL_MAP.put("v24cj6", CHAN_J6);
        CHANNEL_MAP.put("v24cj7", CHAN_J7);
        CHANNEL_MAP.put("v24cj8", CHAN_J8);

        CHANNEL_MAP.put("v24cj9", CHAN_J9);
        CHANNEL_MAP.put("bpuMaq20", CHAN_BPU_MAQ20);
        CHANNEL_MAP.put("v24cj11", CHAN_J11);
        CHANNEL_MAP.put("v24cj12", CHAN_J12);

        CHANNEL_MAP.put("v24cj13", CHAN_J13);
        CHANNEL_MAP.put("v24cj14", CHAN_J14);
        CHANNEL_MAP.put("v24cj15", CHAN_J15);
        CHANNEL_MAP.put("v24cj16", CHAN_J16);
    }

    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_24V_CLEAN);
        VALID_TYPES.add(BoardType.SIMULATED);
    }

    private static final int
        VALID_CHAN_MASK = 0x0fff;


    /**
     *  Constructor.
     */
    public ComCamPdu24VC()
    {
        super(NUM_CHANS, LambdaPS.MODEL_28);
        setValidBoardTypes(VALID_TYPES);
        setValidChannels(VALID_CHAN_MASK);
        setChannelMap(CHANNEL_MAP);
    }

}
