package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling the 24V clean SLAC PDU
 *
 *  @author  Owen Saxton
 */
public class Pdu24VC extends PduHV {

    /**
     *  Constants and data.
     */
    public static final int
        CHAN_ION_PUMPS    = 0,
        CHAN_UNUSED       = 1,
        CHAN_FES_CHANGER  = 2,
        CHAN_BODY_MAQ20   = 3,
        CHAN_SHTR_PLC_1   = 4,
        CHAN_SHTR_PLC_2   = 5,
        CHAN_FES_CAROUSEL = 6,
        CHAN_FES_LOADER   = 7,
        CHAN_CRYO_MAQ20   = 8,
        CHAN_GAUGES       = 9,
        CHAN_INT_VALVES   = 10,
        NUM_CHANS         = 11;

    @Deprecated
    public static final int
        CHAN_UT_MAQ20S    = 8;

    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
        CHANNEL_MAP.put("bodyMaq20", CHAN_BODY_MAQ20);
        CHANNEL_MAP.put("fesChanger", CHAN_FES_CHANGER);
        CHANNEL_MAP.put("fesCarousel", CHAN_FES_CAROUSEL);
        CHANNEL_MAP.put("fesLoader", CHAN_FES_LOADER);
        CHANNEL_MAP.put("shtrPlc1", CHAN_SHTR_PLC_1);
        CHANNEL_MAP.put("shtrPlc2", CHAN_SHTR_PLC_2);
        CHANNEL_MAP.put("cryoMaq20", CHAN_CRYO_MAQ20);
        CHANNEL_MAP.put("ionPumps", CHAN_ION_PUMPS);
        CHANNEL_MAP.put("gauges", CHAN_GAUGES);
        CHANNEL_MAP.put("intValves", CHAN_INT_VALVES);
        CHANNEL_MAP.put("unused", CHAN_UNUSED);
    }

    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_24V_CLEAN);
        VALID_TYPES.add(BoardType.SIMULATED);
    }

    private static final int
        VALID_CHAN_MASK = 0x07fd;


    /**
     *  Constructor.
     */
    public Pdu24VC()
    {
        super(NUM_CHANS, LambdaPS.MODEL_28);
        setValidBoardTypes(VALID_TYPES);
        setValidChannels(VALID_CHAN_MASK);
        setChannelMap(CHANNEL_MAP);
    }

}
