package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling any HV SLAC PDU
 *
 *  @author  Owen Saxton
 */
public class PduHVGen extends PduHV {

    /**
     *  Constants and data.
     */
    public static final int
        CHAN_0  = 0,
        CHAN_1  = 1,
        CHAN_2  = 2,
        CHAN_3  = 3,
        CHAN_4  = 4,
        CHAN_5  = 5,
        CHAN_6  = 6,
        CHAN_7  = 7,
        CHAN_8  = 8,
        CHAN_9  = 9,
        CHAN_10 = 10,
        CHAN_11 = 11,
        NUM_CHANS = 12;

    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
        CHANNEL_MAP.put("channel0", CHAN_0);
        CHANNEL_MAP.put("channel1", CHAN_1);
        CHANNEL_MAP.put("channel2", CHAN_2);
        CHANNEL_MAP.put("channel3", CHAN_3);
        CHANNEL_MAP.put("channel4", CHAN_4);
        CHANNEL_MAP.put("channel5", CHAN_5);
        CHANNEL_MAP.put("channel6", CHAN_6);
        CHANNEL_MAP.put("channel7", CHAN_7);
        CHANNEL_MAP.put("channel8", CHAN_8);
        CHANNEL_MAP.put("channel9", CHAN_9);
        CHANNEL_MAP.put("channel10", CHAN_10);
        CHANNEL_MAP.put("channel11", CHAN_11);
    }

    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_24V_CLEAN);
        VALID_TYPES.add(BoardType.PDU_24V_DIRTY);
        VALID_TYPES.add(BoardType.PDU_48V);
        VALID_TYPES.add(BoardType.SIMULATED);
    }

    private static final int
        VALID_CHAN_MASK = 0x0fff;


    /**
     *  Constructor.
     *
     *  @param  mainModel  The model of the main (Lambda) power supply
     */
    public PduHVGen(int mainModel)
    {
        super(NUM_CHANS, mainModel);
        setValidBoardTypes(VALID_TYPES);
        setValidChannels(VALID_CHAN_MASK);
        setChannelMap(CHANNEL_MAP);
    }

}
