package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling the 24V dirty SLAC PDU
 *
 *  @author  CCS
 */
public class ComCamPdu24VD extends PduHV {

    /**
     *  Constants and data.
     */

    /*
1 - ion pump
2 - not assigned
3 - path finder turbo pump
4 - path finder filter changer
5 - scroll lab pump (moved to 7)
6 - cryo turbo
7 - not assigned
8 - 
    */
    public static final int
	CHAN_J5            = 0, // J5
        CHAN_FES_LOADER_D  = 1,
        CHAN_J7            = 2,
        CHAN_J8            = 3, // J8

        CHAN_PFTURBO       = 4, // J9
        CHAN_FES           = 5,
        CHAN_PFSCROLL      = 6, // J11
        CHAN_J12           = 7, // J12

        CHAN_TURBO_HEATER  = 8, // J13
        CHAN_J14           = 9, // J14
        CHAN_J15           = 10, // J15
        CHAN_J16           = 11, // J16

        NUM_CHANS          = 12;

    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
        CHANNEL_MAP.put("v24dj5", CHAN_J5);
	//        CHANNEL_MAP.put("ionPump",   CHAN_ION_PUMP);
        CHANNEL_MAP.put("fesLoader", CHAN_FES_LOADER_D);
        CHANNEL_MAP.put("v24dj7", CHAN_J7);
        CHANNEL_MAP.put("v24dj8", CHAN_J8);

        CHANNEL_MAP.put("PFTurbo", CHAN_PFTURBO);
        CHANNEL_MAP.put("fes", CHAN_FES);
        CHANNEL_MAP.put("PFScroll", CHAN_PFSCROLL);
	//        CHANNEL_MAP.put("cryoTurbo", CHAN_CRYO_TURBO);
        CHANNEL_MAP.put("v24dj12", CHAN_J12);

	//        CHANNEL_MAP.put("shuBrakes", CHAN_SHUTTER_BRAKE);
        CHANNEL_MAP.put("TurboHeater", CHAN_TURBO_HEATER);
        CHANNEL_MAP.put("v24dj14", CHAN_J14);
        CHANNEL_MAP.put("v24dj15", CHAN_J15);
        CHANNEL_MAP.put("v24dj16", CHAN_J16);
    }

    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_24V_DIRTY);
        VALID_TYPES.add(BoardType.SIMULATED);
    }

    private static final int
        VALID_CHAN_MASK = 0xfff;


    /**
     *  Constructor.
     */
    public ComCamPdu24VD()
    {
        super(NUM_CHANS, LambdaPS.MODEL_28);
        setValidBoardTypes(VALID_TYPES);
        setValidChannels(VALID_CHAN_MASK);
        setChannelMap(CHANNEL_MAP);
    }

}
